/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import me.henrytao.mdcore.core.MdCompat;
import me.henrytao.mdcore.widgets.CircularRevealFrameLayout;
import me.henrytao.mdcore.widgets.arcanimator.AlphaAnimator;
import me.henrytao.mdcore.widgets.arcanimator.ArcAnimator;
import me.henrytao.mdcore.widgets.arcanimator.Side;

@TargetApi(value=11)
public class FabSheetWindow {
    private static final AccelerateInterpolator ACCELERATE = new AccelerateInterpolator();
    private static final DecelerateInterpolator DECELERATE = new DecelerateInterpolator();
    private final int mBackgroundColor;
    private final int mDegree;
    private final long mDuration;
    private final Integer mFabMaxBottom;
    private Context mContext;
    private Animator mFabAnimation;
    private FabInfo mFabInfo;
    private boolean mIsCreated;
    private OnDismissListener mOnDismissListener;
    private OnShowListener mOnShowListener;
    private Animator mOverlayAnimation;
    private Animator mSheetAnimation;
    private boolean mShowing;
    private ViewGroup vContent;
    private FloatingActionButton vFab;
    private ViewGroup vOverlay;
    private ViewGroup vRoot;
    private View vSheet;
    private CircularRevealFrameLayout vSheetContainer;

    private static void onAnimationEnd(Animator animation, final @NonNull OnAnimationEndListener onAnimationEndListener) {
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                onAnimationEndListener.onAnimationEnd(animation);
                animation.removeListener((Animator.AnimatorListener)this);
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationStart(Animator animation) {
            }
        });
    }

    private static void onAnimationStart(Animator animation, final @NonNull OnAnimationStartListener onAnimationStartListener) {
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                animation.removeListener((Animator.AnimatorListener)this);
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationStart(Animator animation) {
                onAnimationStartListener.onAnimationStart(animation);
            }
        });
    }

    private FabSheetWindow(FloatingActionButton fab, View sheet, int backgroundColor, int degree, long duration, Integer fabMaxBottom, OnShowListener onShowListener, OnDismissListener onDismissListener) {
        this.mContext = fab.getContext().getApplicationContext();
        this.vFab = fab;
        this.vSheet = sheet;
        this.mBackgroundColor = backgroundColor;
        this.mDegree = degree;
        this.mDuration = duration;
        this.mFabMaxBottom = fabMaxBottom;
        this.mOnShowListener = onShowListener;
        this.mOnDismissListener = onDismissListener;
    }

    public void destroy() {
        this.onDestroyView();
    }

    public void dismiss() {
        if (!this.mIsCreated) {
            return;
        }
        if (this.isAnimating() || !this.isShowing()) {
            return;
        }
        this.mFabAnimation = this.createFabDimissAnimation().setDuration(this.mDuration);
        this.mSheetAnimation = this.createSheetDismissAnimation().setDuration(this.mDuration);
        this.mOverlayAnimation = this.createOverlayDismissAnimation().setDuration(this.mDuration);
        this.mFabAnimation.setStartDelay(this.mDuration);
        FabSheetWindow.onAnimationEnd(this.mFabAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                FabSheetWindow.this.mShowing = false;
                if (FabSheetWindow.this.mOnDismissListener != null) {
                    FabSheetWindow.this.mOnDismissListener.onDismiss(FabSheetWindow.this);
                }
            }
        });
        FabSheetWindow.onAnimationEnd(this.mSheetAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                FabSheetWindow.this.vSheetContainer.setVisibility(8);
            }
        });
        FabSheetWindow.onAnimationEnd(this.mOverlayAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                FabSheetWindow.this.vOverlay.setVisibility(8);
            }
        });
        this.mFabAnimation.start();
        this.mSheetAnimation.start();
        this.mOverlayAnimation.start();
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void reset() {
        if (!this.mIsCreated) {
            return;
        }
        this.mShowing = false;
        if (this.mFabAnimation != null) {
            this.mFabAnimation.cancel();
        }
        if (this.mSheetAnimation != null) {
            this.mSheetAnimation.cancel();
        }
        if (this.mOverlayAnimation != null) {
            this.mOverlayAnimation.cancel();
        }
        this.vFab.setVisibility(0);
        ViewCompat.setX((View)this.vFab, (float)this.mFabInfo.relativeTopLeft.x);
        ViewCompat.setY((View)this.vFab, (float)this.mFabInfo.relativeTopLeft.y);
        this.vSheetContainer.setVisibility(8);
        this.vOverlay.setVisibility(8);
    }

    public void show() {
        if (!this.mIsCreated) {
            this.mIsCreated = true;
            this.onCreateView();
        }
        if (this.isAnimating() || this.isShowing()) {
            return;
        }
        this.mShowing = true;
        this.vFab.setVisibility(0);
        this.vSheetContainer.setVisibility(4);
        this.vOverlay.setVisibility(4);
        this.mFabAnimation = this.createFabShowAnimation().setDuration(this.mDuration);
        this.mSheetAnimation = this.createSheetShowAnimation().setDuration(this.mDuration);
        this.mOverlayAnimation = this.createOverlayShowAnimation().setDuration(this.mDuration);
        this.mSheetAnimation.setStartDelay(this.mDuration);
        this.mOverlayAnimation.setStartDelay(this.mDuration / 2L);
        FabSheetWindow.onAnimationStart(this.mSheetAnimation, new OnAnimationStartListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                FabSheetWindow.this.vSheetContainer.setVisibility(0);
            }
        });
        FabSheetWindow.onAnimationStart(this.mOverlayAnimation, new OnAnimationStartListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                FabSheetWindow.this.vOverlay.setVisibility(0);
            }
        });
        FabSheetWindow.onAnimationEnd(this.mSheetAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                if (FabSheetWindow.this.mOnShowListener != null) {
                    FabSheetWindow.this.mOnShowListener.onShow(FabSheetWindow.this);
                }
            }
        });
        this.mFabAnimation.start();
        this.mSheetAnimation.start();
        this.mOverlayAnimation.start();
    }

    private Animator createFabDimissAnimation() {
        ArcAnimator animator = ArcAnimator.create((View)this.vFab, this.mFabInfo.relativeCenter.x, this.mFabInfo.relativeCenter.y, this.mDegree, Side.LEFT);
        animator.setInterpolator((TimeInterpolator)DECELERATE);
        return animator;
    }

    private Animator createFabShowAnimation() {
        FabInfo.Pointer target = this.getTargetRelativePointer();
        ArcAnimator animator = ArcAnimator.create((View)this.vFab, target.x, target.y, this.mDegree, Side.LEFT);
        animator.setInterpolator((TimeInterpolator)ACCELERATE);
        return animator;
    }

    private Animator createOverlayDismissAnimation() {
        AlphaAnimator animator = AlphaAnimator.create((View)this.vOverlay, 1.0f, 0.0f);
        animator.setInterpolator((TimeInterpolator)DECELERATE);
        return animator;
    }

    private Animator createOverlayShowAnimation() {
        AlphaAnimator animator = AlphaAnimator.create((View)this.vOverlay, 0.0f, 1.0f);
        animator.setInterpolator((TimeInterpolator)ACCELERATE);
        return animator;
    }

    private Animator createSheetDismissAnimation() {
        FabInfo.Pointer target = this.getTargetDistance();
        int dx = this.vSheetContainer.getMeasuredWidth() / 2;
        int dy = this.vSheetContainer.getMeasuredHeight() / 2;
        int dyFab = dy + (int)((float)target.y - (this.mFabMaxBottom != null ? (float)Math.min(this.mFabMaxBottom, target.y) : (float)target.y));
        float radius = (float)Math.hypot(dx, Math.max(dy, dyFab));
        Animator animator = MdCompat.createCircularReveal(this.vSheetContainer, dx, dyFab, radius, this.mFabInfo.radius);
        animator.setInterpolator((TimeInterpolator)ACCELERATE);
        return animator;
    }

    private Animator createSheetShowAnimation() {
        FabInfo.Pointer target = this.getTargetDistance();
        int dx = this.vSheetContainer.getMeasuredWidth() / 2;
        int dy = this.vSheetContainer.getMeasuredHeight() / 2;
        int dyFab = dy + (int)((float)target.y - (this.mFabMaxBottom != null ? (float)Math.min(this.mFabMaxBottom, target.y) : (float)target.y));
        float radius = (float)Math.hypot(dx, Math.max(dy, dyFab));
        Animator animator = MdCompat.createCircularReveal(this.vSheetContainer, dx, dyFab, this.mFabInfo.radius, radius);
        animator.setInterpolator((TimeInterpolator)DECELERATE);
        return animator;
    }

    private FabInfo.Pointer getTargetAbsolutePointer() {
        FabInfo.Pointer distance = this.getTargetDistance();
        return new FabInfo.Pointer(this.mFabInfo.center.x - distance.x, this.mFabInfo.center.y - distance.y);
    }

    private FabInfo.Pointer getTargetDistance() {
        float sheetX = this.mFabInfo.bottomRight.x - this.vSheetContainer.getMeasuredWidth();
        float sheetY = this.mFabInfo.bottomRight.y - this.vSheetContainer.getMeasuredHeight();
        float targetX = sheetX + (float)(this.vSheetContainer.getMeasuredWidth() / 2);
        float targetY = sheetY + (float)(this.vSheetContainer.getMeasuredHeight() / 2);
        return new FabInfo.Pointer((float)this.mFabInfo.center.x - targetX, (float)this.mFabInfo.center.y - targetY);
    }

    private FabInfo.Pointer getTargetRelativePointer() {
        FabInfo.Pointer distance = this.getTargetDistance();
        int x = this.mFabInfo.relativeCenter.x - distance.x;
        int y = this.mFabInfo.relativeCenter.y - (int)(this.mFabMaxBottom != null ? (float)Math.min(this.mFabMaxBottom, distance.y) : (float)distance.y);
        return new FabInfo.Pointer(x, y);
    }

    private boolean isAnimating() {
        return this.mFabAnimation != null && this.mSheetAnimation != null && this.mOverlayAnimation != null && (this.mFabAnimation.isRunning() || this.mSheetAnimation.isRunning() || this.mOverlayAnimation.isRunning());
    }

    private void onCreateView() {
        this.mFabInfo = new FabInfo(this.vFab);
        this.vRoot = (ViewGroup)this.vFab.getRootView();
        this.vOverlay = new FrameLayout(this.mContext);
        this.vOverlay.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.vOverlay.setBackgroundColor(this.mBackgroundColor);
        this.vRoot.addView((View)this.vOverlay);
        this.vContent = new FrameLayout(this.mContext);
        this.vContent.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.vRoot.addView((View)this.vContent);
        this.vSheetContainer = new CircularRevealFrameLayout(this.mContext);
        this.vSheetContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.vSheetContainer.addView(this.vSheet, new ViewGroup.LayoutParams(-2, -2));
        this.vContent.addView((View)this.vSheetContainer);
        this.vOverlay.measure(0, 0);
        this.vContent.measure(0, 0);
        ViewCompat.setX((View)this.vSheetContainer, (float)(this.mFabInfo.bottomRight.x - this.vSheetContainer.getMeasuredWidth()));
        ViewCompat.setY((View)this.vSheetContainer, (float)(this.mFabInfo.bottomRight.y - this.vSheetContainer.getMeasuredHeight()));
        this.vOverlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FabSheetWindow.this.dismiss();
            }
        });
    }

    private void onDestroyView() {
        this.mContext = null;
        if (this.mFabAnimation != null) {
            this.mFabAnimation.end();
        }
        this.mFabAnimation = null;
        if (this.mOverlayAnimation != null) {
            this.mOverlayAnimation.end();
        }
        this.mOverlayAnimation = null;
        if (this.mSheetAnimation != null) {
            this.mSheetAnimation.end();
        }
        this.mSheetAnimation = null;
        this.vRoot.removeView((View)this.vOverlay);
        this.vRoot.removeView((View)this.vContent);
        this.vRoot = null;
        this.vOverlay = null;
        this.vContent = null;
        this.vSheetContainer = null;
        this.vSheet = null;
        this.vFab = null;
        this.mOnShowListener = null;
        this.mOnDismissListener = null;
    }

    private static class FabInfo {
        private static final int FAB_SIZE = 48;
        private final Pointer bottomRight;
        private final Pointer center;
        private final int height;
        private final float radius;
        private final Pointer relativeBottomRight;
        private final Pointer relativeCenter;
        private final Pointer relativeTopLeft;
        private final Pointer topLeft;
        private final int width;

        FabInfo(FloatingActionButton fab) {
            int[] location = new int[2];
            fab.getLocationInWindow(location);
            this.width = fab.getMeasuredWidth();
            this.height = fab.getMeasuredHeight();
            this.topLeft = new Pointer(location[0], location[1]);
            this.center = new Pointer(this.topLeft.x + this.width / 2, this.topLeft.y + this.height / 2);
            this.bottomRight = new Pointer(this.topLeft.x + this.width, this.topLeft.y + this.height);
            this.relativeTopLeft = new Pointer(ViewCompat.getX((View)fab), ViewCompat.getY((View)fab));
            this.relativeCenter = new Pointer(this.relativeTopLeft.x + this.width / 2, this.relativeTopLeft.y + this.height / 2);
            this.relativeBottomRight = new Pointer(this.relativeTopLeft.x + this.width, this.relativeTopLeft.y + this.height);
            this.radius = Math.min(this.width / 2, MdCompat.dpToPx(48));
        }

        private static class Pointer {
            private final int x;
            private final int y;

            Pointer(int x, int y) {
                this.x = x;
                this.y = y;
            }

            Pointer(float x, float y) {
                this((int)x, (int)y);
            }
        }
    }

    public static class Builder {
        private static final int BACKGROUND_COLOR = Color.parseColor((String)"#4C000000");
        private static final int DEGREE = 45;
        private static final long DURATION = 200L;
        private int mBackgroundColor = BACKGROUND_COLOR;
        private int mDegree = 45;
        private long mDuration = 200L;
        private Integer mFabMaxBottom = null;
        private OnDismissListener mOnDismissListener;
        private OnShowListener mOnShowListener;
        private FloatingActionButton vFab;
        private View vSheet;

        public Builder(FloatingActionButton fab, View sheet) {
            this.vFab = fab;
            this.vSheet = sheet;
        }

        public FabSheetWindow build() {
            return new FabSheetWindow(this.vFab, this.vSheet, this.mBackgroundColor, this.mDegree, this.mDuration, this.mFabMaxBottom, this.mOnShowListener, this.mOnDismissListener);
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setDegree(int degree) {
            this.mDegree = degree;
            return this;
        }

        public Builder setDuration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder setFabMaxBottom(int fabMaxBottom) {
            this.mFabMaxBottom = fabMaxBottom;
            return this;
        }

        public Builder setOnDismissListener(OnDismissListener onDismissListener) {
            this.mOnDismissListener = onDismissListener;
            return this;
        }

        public Builder setOnShowListener(OnShowListener onShowListener) {
            this.mOnShowListener = onShowListener;
            return this;
        }
    }

    public static interface OnShowListener {
        public void onShow(FabSheetWindow var1);
    }

    public static interface OnDismissListener {
        public void onDismiss(FabSheetWindow var1);
    }

    private static interface OnAnimationStartListener {
        public void onAnimationStart(Animator var1);
    }

    private static interface OnAnimationEndListener {
        public void onAnimationEnd(Animator var1);
    }
}

