/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.core;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.util.AttributeSet;
import android.util.Xml;
import me.henrytao.mdcore.core.MdCompat;
import me.henrytao.mdcore.utils.Ln;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MdVectorDrawableCompat {
    @Nullable
    public static VectorDrawableCompat create(@NonNull Context context, @DrawableRes int resId) {
        Resources res = context.getResources();
        Resources.Theme theme = context.getTheme();
        VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)res, (int)resId, (Resources.Theme)theme);
        if (Build.VERSION.SDK_INT < 23) {
            try {
                int type;
                XmlResourceParser parser = res.getXml(resId);
                AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new XmlPullParserException("No start tag found");
                }
                TypedArray a = theme.obtainStyledAttributes(attrs, new int[]{0x1010121}, 0, 0);
                int tintId = a.getResourceId(0, 0);
                a.recycle();
                drawable.setTintList(MdCompat.getColorStateList(context, tintId));
            }
            catch (Exception e) {
                Ln.d(e);
            }
        }
        return drawable;
    }

    @Nullable
    public static VectorDrawableCompat getFromAttribute(@NonNull Context context, AttributeSet attrs, int attrId) {
        VectorDrawableCompat drawable = null;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{attrId}, 0, 0);
        try {
            int resId = a.getResourceId(0, 0);
            if (resId > 0) {
                drawable = MdVectorDrawableCompat.create(context, resId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        return drawable;
    }

    @NonNull
    public static VectorDrawableCompat[] getFromAttribute(@NonNull Context context, AttributeSet attrs, int ... attrIds) {
        VectorDrawableCompat[] drawables = new VectorDrawableCompat[attrIds.length];
        for (int i = 0; i < attrIds.length; ++i) {
            drawables[i] = MdVectorDrawableCompat.getFromAttribute(context, attrs, attrIds[i]);
        }
        return drawables;
    }
}

