/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.core;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.view.LayoutInflaterFactory;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.DialogTitle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.core.MdCompat;
import me.henrytao.mdcore.core.MdVectorDrawableCompat;
import me.henrytao.mdcore.utils.Ln;
import me.henrytao.mdcore.utils.Typography;
import me.henrytao.mdcore.widgets.internal.MdCheckBox;
import me.henrytao.mdcore.widgets.internal.MdToolbar;

public class MdLayoutInflaterFactory
implements LayoutInflaterFactory {
    private final AppCompatDelegate mDelegate;

    public MdLayoutInflaterFactory(@NonNull AppCompatDelegate delegate) {
        this.mDelegate = delegate;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        Ln.d("custom | %s | %s", new Object[]{name, attrs.getClass().toString()});
        View view = this.onCreateCustomView(parent, name, context, attrs);
        this.onSupportView(view, parent, name, context, attrs);
        return view;
    }

    protected View onCreateCustomView(View parent, String name, Context context, AttributeSet attrs) {
        if (TextUtils.equals((CharSequence)name, (CharSequence)"CheckBox")) {
            return new MdCheckBox(context, attrs);
        }
        if (TextUtils.equals((CharSequence)name, (CharSequence)"android.support.v7.widget.Toolbar")) {
            return new MdToolbar(context, attrs);
        }
        if (TextUtils.equals((CharSequence)name, (CharSequence)"android.support.v7.widget.DialogTitle")) {
            return new DialogTitle(context, attrs);
        }
        return this.mDelegate.createView(parent, name, context, attrs);
    }

    protected void onSupportView(View view, View parent, String name, Context context, AttributeSet attrs) {
        this.supportImageView(context, view instanceof ImageView ? (ImageView)view : null, attrs);
        this.supportCheckBox(context, view instanceof CheckBox ? (CheckBox)view : null, attrs);
        this.supportButton(context, view instanceof Button ? (Button)view : null, attrs);
        this.supportTextView(context, view instanceof TextView ? (TextView)view : null, attrs);
    }

    protected void supportButton(Context context, Button view, AttributeSet attrs) {
        ColorStateList textColor;
        if (view == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{16842904}, R.attr.buttonStyle, 0);
        try {
            textColor = MdCompat.getColorStateList(context, a.getResourceId(0, 0));
        }
        catch (Exception ignore) {
            textColor = a.getColorStateList(0);
        }
        a.recycle();
        if (textColor != null) {
            view.setTextColor(textColor);
        }
    }

    protected void supportCheckBox(Context context, CheckBox view, AttributeSet attrs) {
        if (view == null) {
            return;
        }
        VectorDrawableCompat drawable = MdVectorDrawableCompat.getFromAttribute(context, attrs, R.attr.srcCompat);
        if (drawable != null) {
            view.setButtonDrawable((Drawable)drawable);
        }
    }

    protected void supportImageView(Context context, ImageView view, AttributeSet attrs) {
        if (view == null) {
            return;
        }
        this.supportVectorDrawable(context, view, attrs);
        boolean isEnabled = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.enabled}, 0, 0);
        try {
            isEnabled = a.getBoolean(0, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        view.setEnabled(isEnabled);
    }

    protected void supportTextView(Context context, TextView view, AttributeSet attrs) {
        if (view == null) {
            return;
        }
        this.supportTypeface(context, view, attrs);
        this.supportVectorDrawable(context, view, attrs);
        this.supportLeading(context, view, attrs);
    }

    protected void supportTypeface(Context context, TextView view, AttributeSet attrs) {
        if (view == null) {
            return;
        }
        Typeface typeface = Typography.getTypeface(context, attrs, view instanceof Button ? R.attr.buttonStyle : 0, 0);
        Typeface typeface2 = typeface = typeface != null ? typeface : Typography.getDefaultTypeface(context);
        if (typeface != null && view.getTypeface() != typeface) {
            view.setTypeface(typeface);
        }
    }

    protected void supportVectorDrawable(Context context, ImageView view, AttributeSet attrs) {
        VectorDrawableCompat srcCompat = MdVectorDrawableCompat.getFromAttribute(context, attrs, R.attr.srcCompat);
        if (srcCompat != null) {
            view.setImageDrawable((Drawable)srcCompat);
        }
    }

    protected void supportVectorDrawable(Context context, TextView view, AttributeSet attrs) {
        VectorDrawableCompat[] drawablesCompat = MdVectorDrawableCompat.getFromAttribute(context, attrs, R.attr.drawableLeftCompat, R.attr.drawableTopCompat, R.attr.drawableRightCompat, R.attr.drawableBottomCompat, R.attr.drawableStartCompat, R.attr.drawableEndCompat);
        boolean shouldInitiate = false;
        for (VectorDrawableCompat drawable : drawablesCompat) {
            if (drawable == null) continue;
            shouldInitiate = true;
            break;
        }
        if (shouldInitiate) {
            Drawable[] drawables = view.getCompoundDrawables();
            Drawable[] drawablesRelative = Build.VERSION.SDK_INT >= 17 ? view.getCompoundDrawablesRelative() : drawables;
            if (Build.VERSION.SDK_INT >= 17) {
                view.setCompoundDrawablesRelativeWithIntrinsicBounds(this.getDrawable((Drawable)(drawablesCompat[4] != null ? drawablesCompat[4] : drawablesCompat[0]), drawablesRelative[0], drawables[0]), this.getDrawable((Drawable)drawablesCompat[1], drawablesRelative[1], drawables[1]), this.getDrawable((Drawable)(drawablesCompat[5] != null ? drawablesCompat[5] : drawablesCompat[2]), drawablesRelative[2], drawables[2]), this.getDrawable((Drawable)drawablesCompat[3], drawablesRelative[3], drawables[3]));
            } else {
                view.setCompoundDrawablesWithIntrinsicBounds(this.getDrawable((Drawable)(drawablesCompat[4] != null ? drawablesCompat[4] : drawablesCompat[0]), drawablesRelative[0], drawables[0]), this.getDrawable((Drawable)drawablesCompat[1], drawablesRelative[1], drawables[1]), this.getDrawable((Drawable)(drawablesCompat[5] != null ? drawablesCompat[5] : drawablesCompat[2]), drawablesRelative[2], drawables[2]), this.getDrawable((Drawable)drawablesCompat[3], drawablesRelative[3], drawables[3]));
            }
        }
    }

    private Drawable getDrawable(Drawable compat, Drawable relative, Drawable normal) {
        return compat != null ? compat : (relative != null ? relative : normal);
    }

    private void supportLeading(Context context, TextView view, AttributeSet attrs) {
        int leading = 0;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.mdLeading}, 0, 0);
        try {
            leading = a.getDimensionPixelSize(0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        MdCompat.applyLeading(view, leading);
    }
}

