/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets.arcanimator;

import android.graphics.PointF;
import java.util.Arrays;
import me.henrytao.mdcore.widgets.arcanimator.Side;
import me.henrytao.mdcore.widgets.arcanimator.Utils;

class ArcMetric {
    float mAnimationDegree;
    PointF[] mAxisPoint = new PointF[2];
    float mEndDegree;
    PointF mEndPoint = new PointF();
    float mMidAxisSegment;
    PointF mMidPoint = new PointF();
    float mRadius;
    Side mSide;
    float mSideDegree;
    float mStartDegree;
    float mStartEndSegment;
    PointF mStartPoint = new PointF();
    PointF mZeroPoint = new PointF();
    float mZeroStartDegree;
    float mZeroStartSegment;

    public static ArcMetric evaluate(float startX, float startY, float endX, float endY, float degree, Side side) {
        ArcMetric arcMetric = new ArcMetric();
        arcMetric.mStartPoint.set(startX, startY);
        arcMetric.mEndPoint.set(endX, endY);
        arcMetric.setDegree(degree);
        arcMetric.mSide = side;
        arcMetric.createAxisVariables();
        arcMetric.calcStartEndSeg();
        arcMetric.calcRadius();
        arcMetric.calcMidAxisSeg();
        arcMetric.calcMidPoint();
        arcMetric.calcAxisPoints();
        arcMetric.calcZeroPoint();
        arcMetric.calcDegrees();
        return arcMetric;
    }

    protected ArcMetric() {
    }

    public String toString() {
        return "ArcMetric{\nmStartPoint=" + this.mStartPoint + "\n mEndPoint=" + this.mEndPoint + "\n mMidPoint=" + this.mMidPoint + "\n mAxisPoint=" + Arrays.toString(this.mAxisPoint) + "\n mZeroPoint=" + this.mZeroPoint + "\n mStartEndSegment=" + this.mStartEndSegment + "\n mRadius=" + this.mRadius + "\n mMidAxisSegment=" + this.mMidAxisSegment + "\n mZeroStartSegment=" + this.mZeroStartSegment + "\n mAnimationDegree=" + this.mAnimationDegree + "\n mSideDegree=" + this.mSideDegree + "\n mZeroStartDegree=" + this.mZeroStartDegree + "\n mStartDegree=" + this.mStartDegree + "\n mEndDegree=" + this.mEndDegree + "\n mSide=" + (Object)((Object)this.mSide) + '}';
    }

    public float getEndDegree() {
        return this.mEndDegree;
    }

    public float getStartDegree() {
        return this.mStartDegree;
    }

    public void setDegree(float degree) {
        if ((degree = Math.abs(degree)) > 180.0f) {
            this.setDegree(degree % 180.0f);
        } else if (degree == 180.0f) {
            this.setDegree(degree - 1.0f);
        } else if (degree < 30.0f) {
            this.setDegree(30.0f);
        } else {
            this.mAnimationDegree = degree;
        }
    }

    PointF getAxisPoint() {
        return this.mAxisPoint[this.mSide.value];
    }

    private void calcAxisPoints() {
        if (this.mStartPoint.y > this.mEndPoint.y || this.mStartPoint.y == this.mEndPoint.y) {
            this.mAxisPoint[0].x = this.mMidPoint.x + this.mMidAxisSegment * (this.mEndPoint.y - this.mStartPoint.y) / this.mStartEndSegment;
            this.mAxisPoint[0].y = this.mMidPoint.y - this.mMidAxisSegment * (this.mEndPoint.x - this.mStartPoint.x) / this.mStartEndSegment;
            this.mAxisPoint[1].x = this.mMidPoint.x - this.mMidAxisSegment * (this.mEndPoint.y - this.mStartPoint.y) / this.mStartEndSegment;
            this.mAxisPoint[1].y = this.mMidPoint.y + this.mMidAxisSegment * (this.mEndPoint.x - this.mStartPoint.x) / this.mStartEndSegment;
        } else {
            this.mAxisPoint[0].x = this.mMidPoint.x - this.mMidAxisSegment * (this.mEndPoint.y - this.mStartPoint.y) / this.mStartEndSegment;
            this.mAxisPoint[0].y = this.mMidPoint.y + this.mMidAxisSegment * (this.mEndPoint.x - this.mStartPoint.x) / this.mStartEndSegment;
            this.mAxisPoint[1].x = this.mMidPoint.x + this.mMidAxisSegment * (this.mEndPoint.y - this.mStartPoint.y) / this.mStartEndSegment;
            this.mAxisPoint[1].y = this.mMidPoint.y - this.mMidAxisSegment * (this.mEndPoint.x - this.mStartPoint.x) / this.mStartEndSegment;
        }
    }

    private void calcDegrees() {
        this.mZeroStartSegment = (float)Math.sqrt(Math.pow(this.mZeroPoint.x - this.mStartPoint.x, 2.0) + Math.pow(this.mZeroPoint.y - this.mStartPoint.y, 2.0));
        this.mZeroStartDegree = Utils.acos((2.0 * Math.pow(this.mRadius, 2.0) - Math.pow(this.mZeroStartSegment, 2.0)) / (2.0 * Math.pow(this.mRadius, 2.0)));
        switch (this.mSide) {
            case RIGHT: {
                if (this.mStartPoint.y <= this.mZeroPoint.y) {
                    if (this.mStartPoint.y > this.mEndPoint.y || this.mStartPoint.y == this.mEndPoint.y && this.mStartPoint.x > this.mEndPoint.x) {
                        this.mStartDegree = this.mZeroStartDegree;
                        this.mEndDegree = this.mStartDegree + this.mAnimationDegree;
                        break;
                    }
                    this.mStartDegree = this.mZeroStartDegree;
                    this.mEndDegree = this.mStartDegree - this.mAnimationDegree;
                    break;
                }
                if (!(this.mStartPoint.y >= this.mZeroPoint.y)) break;
                if (this.mStartPoint.y < this.mEndPoint.y || this.mStartPoint.y == this.mEndPoint.y && this.mStartPoint.x > this.mEndPoint.x) {
                    this.mStartDegree = 0.0f - this.mZeroStartDegree;
                    this.mEndDegree = this.mStartDegree - this.mAnimationDegree;
                    break;
                }
                this.mStartDegree = 0.0f - this.mZeroStartDegree;
                this.mEndDegree = this.mStartDegree + this.mAnimationDegree;
                break;
            }
            case LEFT: {
                if (this.mStartPoint.y <= this.mZeroPoint.y) {
                    if (this.mStartPoint.y > this.mEndPoint.y || this.mStartPoint.y == this.mEndPoint.y && this.mStartPoint.x < this.mEndPoint.x) {
                        this.mStartDegree = 180.0f - this.mZeroStartDegree;
                        this.mEndDegree = this.mStartDegree - this.mAnimationDegree;
                        break;
                    }
                    this.mStartDegree = 180.0f - this.mZeroStartDegree;
                    this.mEndDegree = this.mStartDegree + this.mAnimationDegree;
                    break;
                }
                if (!(this.mStartPoint.y >= this.mZeroPoint.y)) break;
                if (this.mStartPoint.y < this.mEndPoint.y || this.mStartPoint.y == this.mEndPoint.y && this.mStartPoint.x < this.mEndPoint.x) {
                    this.mStartDegree = 180.0f + this.mZeroStartDegree;
                    this.mEndDegree = this.mStartDegree + this.mAnimationDegree;
                    break;
                }
                this.mStartDegree = 180.0f + this.mZeroStartDegree;
                this.mEndDegree = this.mStartDegree - this.mAnimationDegree;
            }
        }
    }

    private void calcMidAxisSeg() {
        this.mMidAxisSegment = this.mRadius * Utils.sin(this.mSideDegree);
    }

    private void calcMidPoint() {
        this.mMidPoint.x = this.mStartPoint.x + this.mStartEndSegment / 2.0f * (this.mEndPoint.x - this.mStartPoint.x) / this.mStartEndSegment;
        this.mMidPoint.y = this.mStartPoint.y + this.mStartEndSegment / 2.0f * (this.mEndPoint.y - this.mStartPoint.y) / this.mStartEndSegment;
    }

    private void calcRadius() {
        this.mSideDegree = (180.0f - this.mAnimationDegree) / 2.0f;
        this.mRadius = this.mStartEndSegment / Utils.sin(this.mAnimationDegree) * Utils.sin(this.mSideDegree);
    }

    private void calcStartEndSeg() {
        this.mStartEndSegment = (float)Math.sqrt(Math.pow(this.mStartPoint.x - this.mEndPoint.x, 2.0) + Math.pow(this.mStartPoint.y - this.mEndPoint.y, 2.0));
    }

    private void calcZeroPoint() {
        switch (this.mSide) {
            case RIGHT: {
                this.mZeroPoint.x = this.mAxisPoint[Side.RIGHT.value].x + this.mRadius;
                this.mZeroPoint.y = this.mAxisPoint[Side.RIGHT.value].y;
                break;
            }
            case LEFT: {
                this.mZeroPoint.x = this.mAxisPoint[Side.LEFT.value].x - this.mRadius;
                this.mZeroPoint.y = this.mAxisPoint[Side.LEFT.value].y;
            }
        }
    }

    private void createAxisVariables() {
        for (int i = 0; i < this.mAxisPoint.length; ++i) {
            this.mAxisPoint[i] = new PointF();
        }
    }
}

