/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets.arcanimator;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.support.annotation.FloatRange;
import android.view.View;
import java.lang.ref.WeakReference;

@TargetApi(value=11)
public class AlphaAnimator
extends ValueAnimator {
    private final float mFromAlpha;
    private final WeakReference<View> mTarget;
    private final float mToAlpha;

    public static AlphaAnimator create(View target, @FloatRange(from=0.0, to=1.0) float fromAlpha, @FloatRange(from=0.0, to=1.0) float toAlpha) {
        return new AlphaAnimator(target, fromAlpha, toAlpha);
    }

    protected AlphaAnimator(View target, float fromAlpha, float toAlpha) {
        this.mTarget = new WeakReference<View>(target);
        this.mFromAlpha = fromAlpha;
        this.mToAlpha = toAlpha;
        this.setFloatValues(new float[]{fromAlpha, toAlpha});
        this.addUpdateListener(new AnimatorUpdateListener(target));
    }

    public void start() {
        View target = (View)this.mTarget.get();
        if (target != null) {
            target.setAlpha(this.mFromAlpha);
        }
        super.start();
    }

    private static class AnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private final WeakReference<View> mTarget;

        public AnimatorUpdateListener(View target) {
            this.mTarget = new WeakReference<View>(target);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            View target = (View)this.mTarget.get();
            if (target != null) {
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                target.setAlpha(alpha);
            }
        }
    }
}

