/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.core;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.view.LayoutInflaterFactory;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.DialogTitle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.core.MdCompat;
import me.henrytao.mdcore.core.MdVectorDrawableCompat;
import me.henrytao.mdcore.utils.Ln;
import me.henrytao.mdcore.utils.Typography;
import me.henrytao.mdcore.widgets.internal.MdCheckBox;
import me.henrytao.mdcore.widgets.internal.MdToolbar;

public class MdLayoutInflaterFactory
implements LayoutInflaterFactory {
    private final AppCompatDelegate mDelegate;

    public MdLayoutInflaterFactory(@NonNull AppCompatDelegate delegate) {
        this.mDelegate = delegate;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        Ln.d("custom | %s | %s", new Object[]{name, attrs.getClass().toString()});
        View view = this.onCreateCustomView(parent, name, context, attrs);
        this.onSupportView(view, parent, name, context, attrs);
        return view;
    }

    protected View onCreateCustomView(View parent, String name, Context context, AttributeSet attrs) {
        if (TextUtils.equals((CharSequence)name, (CharSequence)"CheckBox")) {
            return new MdCheckBox(context, attrs);
        }
        if (TextUtils.equals((CharSequence)name, (CharSequence)"android.support.v7.widget.Toolbar")) {
            return new MdToolbar(context, attrs);
        }
        if (TextUtils.equals((CharSequence)name, (CharSequence)"android.support.v7.widget.DialogTitle")) {
            return new DialogTitle(context, attrs);
        }
        return this.mDelegate.createView(parent, name, context, attrs);
    }

    protected void onSupportView(View view, View parent, String name, Context context, AttributeSet attrs) {
        this.supportImageView(context, view instanceof ImageView ? (ImageView)view : null, attrs);
        this.supportCheckBox(context, view instanceof CheckBox ? (CheckBox)view : null, attrs);
        this.supportButton(context, view instanceof Button ? (Button)view : null, attrs);
        this.supportTypeface(context, view instanceof TextView ? (TextView)view : null, attrs);
    }

    protected void supportButton(Context context, Button button, AttributeSet attrs) {
        ColorStateList textColor;
        if (button == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{16842904}, R.attr.buttonStyle, 0);
        try {
            textColor = MdCompat.getColorStateList(context, a.getResourceId(0, 0));
        }
        catch (Exception ignore) {
            textColor = a.getColorStateList(0);
        }
        a.recycle();
        if (textColor != null) {
            button.setTextColor(textColor);
        }
    }

    protected void supportCheckBox(Context context, CheckBox checkBox, AttributeSet attrs) {
        if (checkBox == null) {
            return;
        }
        VectorDrawableCompat drawable = null;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.srcCompat}, 0, 0);
        try {
            int resId = a.getResourceId(0, 0);
            if (resId > 0) {
                drawable = MdVectorDrawableCompat.create(context, resId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        if (drawable != null) {
            checkBox.setButtonDrawable(drawable);
        }
    }

    protected void supportImageView(Context context, ImageView imageView, AttributeSet attrs) {
        if (imageView == null) {
            return;
        }
        boolean isEnabled = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.enabled}, 0, 0);
        try {
            isEnabled = a.getBoolean(0, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        imageView.setEnabled(isEnabled);
    }

    protected void supportTypeface(Context context, TextView textView, AttributeSet attrs) {
        if (textView == null) {
            return;
        }
        Typeface typeface = Typography.getTypeface(context, attrs, textView instanceof Button ? R.attr.buttonStyle : 0, 0);
        Typeface typeface2 = typeface = typeface != null ? typeface : Typography.getDefaultTypeface(context);
        if (typeface != null && textView.getTypeface() != typeface) {
            textView.setTypeface(typeface);
        }
    }
}

