/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import me.henrytao.mdcore.core.MdCompat;
import me.henrytao.mdcore.widgets.CircularRevealFrameLayout;
import me.henrytao.mdcore.widgets.arcanimator.AlphaAnimator;
import me.henrytao.mdcore.widgets.arcanimator.ArcAnimator;
import me.henrytao.mdcore.widgets.arcanimator.Side;

@TargetApi(value=11)
public class FabSheetWindow {
    private static final AccelerateInterpolator ACCELERATE = new AccelerateInterpolator();
    private static final AccelerateDecelerateInterpolator ACCELERATE_DECELERATE = new AccelerateDecelerateInterpolator();
    private static final DecelerateInterpolator DECELERATE = new DecelerateInterpolator();
    private static final int DEGREE = 45;
    private static final long DURATION = 200L;
    private static final int FAB_SIZE = 48;
    private final FabInfo mFabInfo;
    private Context mContext;
    private int mDegree = 45;
    private long mDuration = 200L;
    private Animator mFabAnimation;
    private boolean mIsCreated;
    private Animator mOverlayAnimation;
    private Animator mSheetAnimation;
    private boolean mShowing;
    private ViewGroup vContent;
    private FloatingActionButton vFab;
    private ViewGroup vOverlay;
    private ViewGroup vRoot;
    private View vSheet;
    private CircularRevealFrameLayout vSheetContainer;

    public static FabSheetWindow create(FloatingActionButton fab, View sheet) {
        return new FabSheetWindow(fab, sheet);
    }

    private static void onAnimationEnd(Animator animation, final @NonNull OnAnimationEndListener onAnimationEndListener) {
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                onAnimationEndListener.onAnimationEnd(animation);
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationStart(Animator animation) {
            }
        });
    }

    protected FabSheetWindow(FloatingActionButton fab, View sheet) {
        this.mContext = fab.getContext().getApplicationContext();
        this.vFab = fab;
        this.vSheet = sheet;
        this.mFabInfo = new FabInfo(this.vFab);
    }

    public void destroy() {
        this.onDestroyView();
    }

    public void dismiss() {
        if (!this.mIsCreated) {
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        this.mFabAnimation = this.createFabDimissAnimation().setDuration(this.getDuration());
        this.mSheetAnimation = this.createSheetDismissAnimation().setDuration(this.getDuration());
        this.mOverlayAnimation = this.createOverlayDismissAnimation().setDuration(this.getDuration());
        this.mFabAnimation.setStartDelay(this.getDuration());
        FabSheetWindow.onAnimationEnd(this.mFabAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                FabSheetWindow.this.mShowing = false;
            }
        });
        FabSheetWindow.onAnimationEnd(this.mSheetAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                FabSheetWindow.this.vSheetContainer.setVisibility(8);
            }
        });
        FabSheetWindow.onAnimationEnd(this.mOverlayAnimation, new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                FabSheetWindow.this.vOverlay.setVisibility(8);
            }
        });
        this.mFabAnimation.start();
        this.mSheetAnimation.start();
        this.mOverlayAnimation.start();
    }

    public int getDegree() {
        return this.mDegree;
    }

    public void setDegree(int degree) {
        this.mDegree = degree;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void show() {
        if (!this.mIsCreated) {
            this.mIsCreated = true;
            this.onCreateView();
        }
        if (this.isAnimating()) {
            return;
        }
        this.mShowing = true;
        this.mFabAnimation = this.createFabShowAnimation().setDuration(this.getDuration());
        this.mSheetAnimation = this.createSheetShowAnimation().setDuration(this.getDuration());
        this.mOverlayAnimation = this.createOverlayShowAnimation().setDuration(this.getDuration());
        this.mSheetAnimation.setStartDelay(this.getDuration());
        this.mOverlayAnimation.setStartDelay(this.getDuration() / 2L);
        this.mFabAnimation.start();
        this.mSheetAnimation.start();
        this.mOverlayAnimation.start();
    }

    protected void onCreateView() {
        this.vRoot = (ViewGroup)this.vFab.getRootView();
        this.vOverlay = new FrameLayout(this.mContext);
        this.vOverlay.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.vOverlay.setBackgroundColor(Color.parseColor((String)"#4C000000"));
        this.vRoot.addView((View)this.vOverlay);
        this.vContent = new FrameLayout(this.mContext);
        this.vContent.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.vRoot.addView((View)this.vContent);
        this.vSheetContainer = new CircularRevealFrameLayout(this.mContext);
        this.vSheetContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.vSheetContainer.addView(this.vSheet, new ViewGroup.LayoutParams(-2, -2));
        this.vContent.addView((View)this.vSheetContainer);
        this.vOverlay.measure(0, 0);
        this.vContent.measure(0, 0);
        ViewCompat.setX((View)this.vSheetContainer, (float)(this.mFabInfo.bottomRight.x - this.vSheetContainer.getMeasuredWidth()));
        ViewCompat.setY((View)this.vSheetContainer, (float)(this.mFabInfo.bottomRight.y - this.vSheetContainer.getMeasuredHeight()));
        this.vOverlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FabSheetWindow.this.dismiss();
            }
        });
    }

    protected void onDestroyView() {
        this.mContext = null;
        if (this.mFabAnimation != null) {
            this.mFabAnimation.end();
        }
        this.mFabAnimation = null;
        if (this.mOverlayAnimation != null) {
            this.mOverlayAnimation.end();
        }
        this.mOverlayAnimation = null;
        if (this.mSheetAnimation != null) {
            this.mSheetAnimation.end();
        }
        this.mSheetAnimation = null;
        this.vRoot.removeView((View)this.vOverlay);
        this.vRoot.removeView((View)this.vContent);
        this.vRoot = null;
        this.vOverlay = null;
        this.vContent = null;
        this.vSheetContainer = null;
        this.vSheet = null;
        this.vFab = null;
    }

    private Animator createFabDimissAnimation() {
        ArcAnimator animator = ArcAnimator.create((View)this.vFab, this.mFabInfo.relativeCenter.x, this.mFabInfo.relativeCenter.y, this.getDegree(), Side.LEFT);
        animator.setInterpolator((TimeInterpolator)DECELERATE);
        return animator;
    }

    private Animator createFabShowAnimation() {
        FabInfo.Pointer target = this.getTargetRelativePointer();
        ArcAnimator animator = ArcAnimator.create((View)this.vFab, target.x, target.y, this.getDegree(), Side.LEFT);
        animator.setInterpolator((TimeInterpolator)ACCELERATE);
        return animator;
    }

    private Animator createOverlayDismissAnimation() {
        AlphaAnimator animator = AlphaAnimator.create((View)this.vOverlay, 1.0f, 0.0f);
        animator.setInterpolator((TimeInterpolator)DECELERATE);
        return animator;
    }

    private Animator createOverlayShowAnimation() {
        AlphaAnimator animator = AlphaAnimator.create((View)this.vOverlay, 0.0f, 1.0f);
        animator.setInterpolator((TimeInterpolator)ACCELERATE);
        return animator;
    }

    private Animator createSheetDismissAnimation() {
        int dx = this.vSheetContainer.getMeasuredWidth() / 2;
        int dy = this.vSheetContainer.getMeasuredHeight() / 2;
        float radius = (float)Math.hypot(dx, dy);
        Animator animator = MdCompat.createCircularReveal(this.vSheetContainer, dx, dy, radius, this.mFabInfo.radius);
        animator.setInterpolator((TimeInterpolator)ACCELERATE_DECELERATE);
        return animator;
    }

    private Animator createSheetShowAnimation() {
        int dx = this.vSheetContainer.getMeasuredWidth() / 2;
        int dy = this.vSheetContainer.getMeasuredHeight() / 2;
        float radius = (float)Math.hypot(dx, dy);
        Animator animator = MdCompat.createCircularReveal(this.vSheetContainer, dx, dy, this.mFabInfo.radius, radius);
        animator.setInterpolator((TimeInterpolator)ACCELERATE_DECELERATE);
        return animator;
    }

    private FabInfo.Pointer getTargetAbsolutePointer() {
        FabInfo.Pointer distance = this.getTargetDistance();
        return new FabInfo.Pointer(this.mFabInfo.center.x - distance.x, this.mFabInfo.center.y - distance.y);
    }

    private FabInfo.Pointer getTargetDistance() {
        float sheetX = this.mFabInfo.bottomRight.x - this.vSheetContainer.getMeasuredWidth();
        float sheetY = this.mFabInfo.bottomRight.y - this.vSheetContainer.getMeasuredHeight();
        float targetX = sheetX + (float)(this.vSheetContainer.getMeasuredWidth() / 2);
        float targetY = sheetY + (float)(this.vSheetContainer.getMeasuredHeight() / 2);
        return new FabInfo.Pointer((float)this.mFabInfo.center.x - targetX, (float)this.mFabInfo.center.y - targetY);
    }

    private FabInfo.Pointer getTargetRelativePointer() {
        FabInfo.Pointer distance = this.getTargetDistance();
        return new FabInfo.Pointer(this.mFabInfo.relativeCenter.x - distance.x, this.mFabInfo.relativeCenter.y - distance.y);
    }

    private boolean isAnimating() {
        return this.mFabAnimation != null && this.mSheetAnimation != null && this.mOverlayAnimation != null && (this.mFabAnimation.isRunning() || this.mSheetAnimation.isRunning() || this.mOverlayAnimation.isRunning());
    }

    private static class FabInfo {
        private final Pointer bottomRight;
        private final Pointer center;
        private final int height;
        private final float radius;
        private final Pointer relativeBottomRight;
        private final Pointer relativeCenter;
        private final Pointer relativeTopLeft;
        private final Pointer topLeft;
        private final int width;

        FabInfo(FloatingActionButton fab) {
            int[] location = new int[2];
            fab.getLocationInWindow(location);
            this.width = fab.getMeasuredWidth();
            this.height = fab.getMeasuredHeight();
            this.topLeft = new Pointer(location[0], location[1]);
            this.center = new Pointer(this.topLeft.x + this.width / 2, this.topLeft.y + this.height / 2);
            this.bottomRight = new Pointer(this.topLeft.x + this.width, this.topLeft.y + this.height);
            this.relativeTopLeft = new Pointer(ViewCompat.getX((View)fab), ViewCompat.getY((View)fab));
            this.relativeCenter = new Pointer(this.relativeTopLeft.x + this.width / 2, this.relativeTopLeft.y + this.height / 2);
            this.relativeBottomRight = new Pointer(this.relativeTopLeft.x + this.width, this.relativeTopLeft.y + this.height);
            this.radius = Math.min(this.width / 2, MdCompat.dpToPx(48));
        }

        private static class Pointer {
            private final int x;
            private final int y;

            Pointer(int x, int y) {
                this.x = x;
                this.y = y;
            }

            Pointer(float x, float y) {
                this((int)x, (int)y);
            }
        }
    }

    private static interface OnAnimationEndListener {
        public void onAnimationEnd(Animator var1);
    }
}

