/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.AttrRes;
import android.support.annotation.StyleRes;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.util.AttributeSet;
import java.util.HashMap;
import java.util.Map;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.core.MdCompat;

public class Typography {
    private static final int FONT_WEIGHT_BLACK = 60;
    private static final int FONT_WEIGHT_BOLD = 50;
    private static final int FONT_WEIGHT_LIGHT = 20;
    private static final int FONT_WEIGHT_MEDIUM = 40;
    private static final int FONT_WEIGHT_REGULAR = 30;
    private static final int FONT_WEIGHT_THIN = 10;
    private static final Map<String, Typeface> sTypefaceCaches = new HashMap<String, Typeface>();

    public static CharSequence applyTypeface(CharSequence text, Typeface typeface) {
        SpannableString s = new SpannableString(text);
        s.setSpan((Object)new TypefaceSpan(typeface), 0, s.length(), 33);
        return s;
    }

    public static Typeface getDefaultTypeface(Context context) {
        return Typography.getTypeface(context, MdCompat.getStringFromAttribute(context, R.attr.mdTypography_default));
    }

    public static Typeface getTypeface(Context context, @StyleRes int resId) {
        String typography = null;
        int fontWeight = 0;
        TypedArray a = context.getTheme().obtainStyledAttributes(resId, R.styleable.MdTypography);
        try {
            fontWeight = a.getInt(R.styleable.MdTypography_mdFontWeight, 0);
            typography = a.getString(R.styleable.MdTypography_mdTypography);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        Typeface typeface = null;
        if (TextUtils.isEmpty(typography) && fontWeight > 0) {
            switch (fontWeight) {
                case 10: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_thin);
                    break;
                }
                case 20: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_light);
                    break;
                }
                case 30: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_regular);
                    break;
                }
                case 40: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_medium);
                    break;
                }
                case 50: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_bold);
                    break;
                }
                case 60: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_black);
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)typography)) {
            typeface = Typography.getTypeface(context, typography);
        }
        return typeface;
    }

    public static Typeface getTypeface(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        String typography = null;
        int fontWeight = 0;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdTypography, defStyleAttr, defStyleRes);
        try {
            fontWeight = a.getInt(R.styleable.MdTypography_mdFontWeight, 0);
            typography = a.getString(R.styleable.MdTypography_mdTypography);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        Typeface typeface = null;
        if (TextUtils.isEmpty(typography) && fontWeight > 0) {
            switch (fontWeight) {
                case 10: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_thin);
                    break;
                }
                case 20: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_light);
                    break;
                }
                case 30: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_regular);
                    break;
                }
                case 40: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_medium);
                    break;
                }
                case 50: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_bold);
                    break;
                }
                case 60: {
                    typography = MdCompat.getStringFromAttribute(context, R.attr.mdTypography_black);
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)typography)) {
            typeface = Typography.getTypeface(context, typography);
        }
        return typeface;
    }

    public static Typeface getTypeface(Context context, String typography) {
        if (TextUtils.isEmpty((CharSequence)typography)) {
            return null;
        }
        if (!sTypefaceCaches.containsKey(typography)) {
            sTypefaceCaches.put(typography, Typeface.createFromAsset((AssetManager)context.getAssets(), (String)typography));
        }
        return sTypefaceCaches.get(typography);
    }

    public static class TypefaceSpan
    extends MetricAffectingSpan {
        private Typeface mTypeface;

        public TypefaceSpan(Typeface typeface) {
            this.mTypeface = typeface;
        }

        public void updateDrawState(TextPaint tp) {
            tp.setTypeface(this.mTypeface);
            tp.setFlags(tp.getFlags() | 0x80);
        }

        public void updateMeasureState(TextPaint p) {
            p.setTypeface(this.mTypeface);
            p.setFlags(p.getFlags() | 0x80);
        }
    }
}

