/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.core;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.view.LayoutInflaterFactory;
import android.support.v7.app.AppCompatDelegate;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.core.MdCompat;
import me.henrytao.mdcore.core.MdVectorDrawableCompat;
import me.henrytao.mdcore.utils.Ln;
import me.henrytao.mdcore.widgets.internal.MdCheckBox;

public class MdLayoutInflaterFactory
implements LayoutInflaterFactory {
    private static final String SUPPORT_CHECK_BOX = "CheckBox";
    private final AppCompatDelegate mDelegate;

    public MdLayoutInflaterFactory(@NonNull AppCompatDelegate delegate) {
        this.mDelegate = delegate;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        MdCheckBox view;
        Ln.d("custom | %s | %s", new Object[]{name, attrs.getClass().toString()});
        switch (name) {
            case "CheckBox": {
                view = new MdCheckBox(context, attrs);
                break;
            }
            default: {
                view = this.mDelegate.createView(parent, name, context, attrs);
            }
        }
        if (view instanceof ImageView) {
            this.supportImageView(context, (ImageView)view, attrs);
        } else if (view instanceof CheckBox) {
            this.supportCheckBox(context, (CheckBox)view, attrs);
        } else if (view instanceof Button) {
            this.supportButton(context, (Button)view, attrs);
        }
        return view;
    }

    private void supportButton(Context context, Button view, AttributeSet attrs) {
        ColorStateList textColor;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextAppearance, 0, 0);
        try {
            textColor = MdCompat.getColorStateList(context, a.getResourceId(R.styleable.TextAppearance_android_textColor, 0));
        }
        catch (Exception ignore) {
            textColor = a.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        a.recycle();
        if (textColor != null) {
            view.setTextColor(textColor);
        }
    }

    private void supportCheckBox(Context context, CheckBox view, AttributeSet attrs) {
        VectorDrawableCompat drawable = null;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.srcCompat}, 0, 0);
        try {
            int resId = a.getResourceId(0, 0);
            if (resId > 0) {
                drawable = MdVectorDrawableCompat.create(context, resId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        if (drawable != null) {
            view.setButtonDrawable(drawable);
        }
    }

    private void supportImageView(Context context, ImageView view, AttributeSet attrs) {
        boolean isEnabled = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, new int[]{R.attr.enabled}, 0, 0);
        try {
            isEnabled = a.getBoolean(0, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        view.setEnabled(isEnabled);
    }
}

