/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.ResourceUtils;

public class MdIcon
extends AppCompatImageView {
    private ColorStateList mImageTintList;
    private PorterDuff.Mode mImageTintMode;

    public MdIcon(Context context) {
        this(context, null);
    }

    public MdIcon(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MdIconStyle);
    }

    public MdIcon(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFromAttributes(attrs, defStyleAttr);
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.invalidateImageTint();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.invalidateImageTint();
    }

    public void setImageTintList(ColorStateList tint) {
        this.mImageTintList = tint;
        this.invalidateImageTint();
    }

    public void setImageTintMode(PorterDuff.Mode tintMode) {
        this.mImageTintMode = tintMode;
        this.invalidateImageTint();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidateImageTint();
    }

    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        ColorStateList imageTintList;
        Context context = this.getContext();
        boolean enabled = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdIcon, defStyleAttr, 0);
        enabled = a.getBoolean(R.styleable.MdIcon_enabled, enabled);
        this.mImageTintMode = ResourceUtils.parseTintMode(a.getInt(R.styleable.MdIcon_tintMode, -1), PorterDuff.Mode.SRC_IN);
        try {
            imageTintList = ResourceUtils.createColorStateListFromResId(context, a.getResourceId(R.styleable.MdIcon_tint, 0));
        }
        catch (Exception ignore) {
            imageTintList = a.getColorStateList(R.styleable.MdIcon_tint);
        }
        a.recycle();
        this.setEnabled(enabled);
        if (imageTintList != null) {
            this.setImageTintList(imageTintList);
        }
    }

    private void invalidateImageTint() {
        super.setImageDrawable(ResourceUtils.createDrawableTint(this.getDrawable(), this.getDrawableState(), this.mImageTintList, this.mImageTintMode));
    }
}

