/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import java.util.HashMap;
import java.util.Map;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.ResourceUtils;

public class MdButton
extends AppCompatButton {
    protected static final int DEFAULT_TYPE = 11;
    protected static Map<Integer, Integer> sButtonInfos = new HashMap<Integer, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getDefaultStyleAttr(Context context, AttributeSet attrs, int styleAttr) {
        if (styleAttr > 0) {
            return styleAttr;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdButton, 0, 0);
        int defStyleAttr = sButtonInfos.get(11);
        try {
            int type = a.getInteger(R.styleable.MdButton_mdb_type, 11);
            if (sButtonInfos.containsKey(type)) {
                defStyleAttr = sButtonInfos.get(type);
            }
        }
        finally {
            a.recycle();
        }
        return defStyleAttr;
    }

    public MdButton(Context context) {
        this(context, null);
    }

    public MdButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MdButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, MdButton.getDefaultStyleAttr(context, attrs, defStyleAttr));
        this.initFromAttributes(attrs, MdButton.getDefaultStyleAttr(context, attrs, defStyleAttr));
    }

    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        ColorStateList textColor;
        Context context = this.getContext();
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextAppearance, defStyleAttr, 0);
        try {
            textColor = ResourceUtils.createColorStateListFromResId(context, a.getResourceId(R.styleable.TextAppearance_android_textColor, 0));
        }
        catch (Exception ignore) {
            textColor = a.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        a.recycle();
        if (textColor != null) {
            this.setTextColor(textColor);
        }
    }

    static {
        sButtonInfos.put(11, R.attr.MdButtonStyle);
        sButtonInfos.put(12, R.attr.MdButtonColoredStyle);
        sButtonInfos.put(13, R.attr.MdButtonBorderlessStyle);
        sButtonInfos.put(14, R.attr.MdButtonBorderlessColoredStyle);
    }
}

