/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;

public class AlertDialogBuilder
extends AlertDialog.Builder {
    protected boolean mAutoDismiss = true;
    protected CharSequence mNegativeButtonText;
    protected DialogInterface.OnClickListener mNegativeOnClickListener;
    protected CharSequence mNeutralButtonText;
    protected DialogInterface.OnClickListener mNeutralOnClickListener;
    protected DialogInterface.OnShowListener mOnShowListener;
    protected CharSequence mPositiveButtonText;
    protected DialogInterface.OnClickListener mPositiveOnClickListener;
    private DialogInterface.OnClickListener mBlankOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
        }
    };

    public AlertDialogBuilder(Context context) {
        super(context);
    }

    public AlertDialogBuilder(Context context, int theme) {
        super(context, theme);
    }

    public AlertDialog create() {
        final AlertDialog alertDialog = super.create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                if (!AlertDialogBuilder.this.mAutoDismiss) {
                    Button positiveButton = alertDialog.getButton(-1);
                    Button negativeButton = alertDialog.getButton(-2);
                    Button neutralButton = alertDialog.getButton(-3);
                    positiveButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (AlertDialogBuilder.this.mPositiveOnClickListener != null) {
                                AlertDialogBuilder.this.mPositiveOnClickListener.onClick((DialogInterface)alertDialog, -1);
                            }
                        }
                    });
                    negativeButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (AlertDialogBuilder.this.mNegativeOnClickListener != null) {
                                AlertDialogBuilder.this.mNegativeOnClickListener.onClick((DialogInterface)alertDialog, -2);
                            }
                        }
                    });
                    neutralButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (AlertDialogBuilder.this.mNeutralOnClickListener != null) {
                                AlertDialogBuilder.this.mNeutralOnClickListener.onClick((DialogInterface)alertDialog, -3);
                            }
                        }
                    });
                }
                if (AlertDialogBuilder.this.mOnShowListener != null) {
                    AlertDialogBuilder.this.mOnShowListener.onShow(dialog);
                }
            }
        });
        return alertDialog;
    }

    public Context getContext() {
        return super.getContext();
    }

    public AlertDialogBuilder setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
        super.setAdapter(adapter, listener);
        return this;
    }

    public AlertDialogBuilder setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        return this;
    }

    public AlertDialogBuilder setCursor(Cursor cursor, DialogInterface.OnClickListener listener, String labelColumn) {
        super.setCursor(cursor, listener, labelColumn);
        return this;
    }

    public AlertDialogBuilder setCustomTitle(View customTitleView) {
        super.setCustomTitle(customTitleView);
        return this;
    }

    public AlertDialogBuilder setIcon(int iconId) {
        super.setIcon(iconId);
        return this;
    }

    public AlertDialogBuilder setIcon(Drawable icon) {
        super.setIcon(icon);
        return this;
    }

    public AlertDialogBuilder setIconAttribute(int attrId) {
        super.setIconAttribute(attrId);
        return this;
    }

    public AlertDialogBuilder setInverseBackgroundForced(boolean useInverseBackground) {
        super.setInverseBackgroundForced(useInverseBackground);
        return this;
    }

    public AlertDialogBuilder setItems(int itemsId, DialogInterface.OnClickListener listener) {
        super.setItems(itemsId, listener);
        return this;
    }

    public AlertDialogBuilder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
        super.setItems(items, listener);
        return this;
    }

    public AlertDialogBuilder setMessage(int messageId) {
        super.setMessage(messageId);
        return this;
    }

    public AlertDialogBuilder setMessage(CharSequence message) {
        super.setMessage(message);
        return this;
    }

    public AlertDialogBuilder setMultiChoiceItems(int itemsId, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
        super.setMultiChoiceItems(itemsId, checkedItems, listener);
        return this;
    }

    public AlertDialogBuilder setMultiChoiceItems(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
        super.setMultiChoiceItems(items, checkedItems, listener);
        return this;
    }

    public AlertDialogBuilder setMultiChoiceItems(Cursor cursor, String isCheckedColumn, String labelColumn, DialogInterface.OnMultiChoiceClickListener listener) {
        super.setMultiChoiceItems(cursor, isCheckedColumn, labelColumn, listener);
        return this;
    }

    public AlertDialogBuilder setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        super.setNegativeButton(textId, listener);
        this.mNegativeButtonText = this.getContext().getText(textId);
        this.mNegativeOnClickListener = listener;
        return this;
    }

    public AlertDialogBuilder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        super.setNegativeButton(text, listener);
        this.mNegativeButtonText = text;
        this.mNegativeOnClickListener = listener;
        return this;
    }

    public AlertDialogBuilder setNeutralButton(int textId, DialogInterface.OnClickListener listener) {
        super.setNeutralButton(textId, listener);
        this.mNeutralButtonText = this.getContext().getText(textId);
        this.mNeutralOnClickListener = listener;
        return this;
    }

    public AlertDialogBuilder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
        super.setNeutralButton(text, listener);
        this.mNeutralButtonText = text;
        this.mNeutralOnClickListener = listener;
        return this;
    }

    public AlertDialogBuilder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        super.setOnCancelListener(onCancelListener);
        return this;
    }

    public AlertDialogBuilder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        super.setOnDismissListener(onDismissListener);
        return this;
    }

    public AlertDialogBuilder setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        super.setOnItemSelectedListener(listener);
        return this;
    }

    public AlertDialogBuilder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        super.setOnKeyListener(onKeyListener);
        return this;
    }

    public AlertDialogBuilder setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        super.setPositiveButton(textId, listener);
        this.mPositiveButtonText = this.getContext().getText(textId);
        this.mPositiveOnClickListener = listener;
        return this;
    }

    public AlertDialogBuilder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        super.setPositiveButton(text, listener);
        this.mPositiveButtonText = text;
        this.mPositiveOnClickListener = listener;
        return this;
    }

    public AlertDialogBuilder setRecycleOnMeasureEnabled(boolean enabled) {
        super.setRecycleOnMeasureEnabled(enabled);
        return this;
    }

    public AlertDialogBuilder setSingleChoiceItems(int itemsId, int checkedItem, DialogInterface.OnClickListener listener) {
        super.setSingleChoiceItems(itemsId, checkedItem, listener);
        return this;
    }

    public AlertDialogBuilder setSingleChoiceItems(Cursor cursor, int checkedItem, String labelColumn, DialogInterface.OnClickListener listener) {
        super.setSingleChoiceItems(cursor, checkedItem, labelColumn, listener);
        return this;
    }

    public AlertDialogBuilder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
        super.setSingleChoiceItems(items, checkedItem, listener);
        return this;
    }

    public AlertDialogBuilder setSingleChoiceItems(ListAdapter adapter, int checkedItem, DialogInterface.OnClickListener listener) {
        super.setSingleChoiceItems(adapter, checkedItem, listener);
        return this;
    }

    public AlertDialogBuilder setTitle(int titleId) {
        super.setTitle(titleId);
        return this;
    }

    public AlertDialogBuilder setTitle(CharSequence title) {
        super.setTitle(title);
        return this;
    }

    public AlertDialogBuilder setView(int layoutResId) {
        super.setView(layoutResId);
        return this;
    }

    public AlertDialogBuilder setView(View view) {
        super.setView(view);
        return this;
    }

    public AlertDialogBuilder setView(View view, int viewSpacingLeft, int viewSpacingTop, int viewSpacingRight, int viewSpacingBottom) {
        super.setView(view, viewSpacingLeft, viewSpacingTop, viewSpacingRight, viewSpacingBottom);
        return this;
    }

    public AlertDialog show() {
        return super.show();
    }

    public AlertDialogBuilder setAutoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
        return this;
    }

    public AlertDialogBuilder setNegativeButton(int textId) {
        this.setNegativeButton(textId, this.mBlankOnClickListener);
        return this;
    }

    public AlertDialogBuilder setNegativeButton(CharSequence text) {
        this.setNegativeButton(text, this.mBlankOnClickListener);
        return this;
    }

    public AlertDialogBuilder setNeutralButton(int textId) {
        this.setNeutralButton(textId, this.mBlankOnClickListener);
        return this;
    }

    public AlertDialogBuilder setNeutralButton(CharSequence text) {
        this.setNeutralButton(text, this.mBlankOnClickListener);
        return this;
    }

    public AlertDialogBuilder setOnNegativeClickListener(DialogInterface.OnClickListener negativeOnClickListener) {
        this.mNegativeOnClickListener = negativeOnClickListener;
        this.setNegativeButton(TextUtils.isEmpty((CharSequence)this.mNegativeButtonText) ? "" : this.mNegativeButtonText, negativeOnClickListener);
        return this;
    }

    public AlertDialogBuilder setOnNeutralClickListener(DialogInterface.OnClickListener neutralOnClickListener) {
        this.mNeutralOnClickListener = neutralOnClickListener;
        this.setNeutralButton(TextUtils.isEmpty((CharSequence)this.mNeutralButtonText) ? "" : this.mNeutralButtonText, neutralOnClickListener);
        return this;
    }

    public AlertDialogBuilder setOnPositiveClickListener(DialogInterface.OnClickListener positiveOnClickListener) {
        this.mPositiveOnClickListener = positiveOnClickListener;
        this.setPositiveButton(TextUtils.isEmpty((CharSequence)this.mPositiveButtonText) ? "" : this.mPositiveButtonText, positiveOnClickListener);
        return this;
    }

    public AlertDialogBuilder setOnShowListener(DialogInterface.OnShowListener onShowListener) {
        this.mOnShowListener = onShowListener;
        return this;
    }

    public AlertDialogBuilder setPositiveButton(CharSequence text) {
        this.setPositiveButton(text, this.mBlankOnClickListener);
        return this;
    }

    public AlertDialogBuilder setPositiveButton(int textId) {
        this.setPositiveButton(textId, this.mBlankOnClickListener);
        return this;
    }
}

