/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class MdButton
extends AppCompatButton {
    protected static final int DEFAULT_TYPE = 11;
    protected static Map<Integer, Integer> sButtonInfos = new HashMap<Integer, Integer>();
    protected int mType;
    private int mTextColorId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getDefaultStyleAttr(Context context, AttributeSet attrs, int styleAttr) {
        if (styleAttr > 0) {
            return styleAttr;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdButton, 0, 0);
        int defStyleAttr = sButtonInfos.get(11);
        try {
            int type = a.getInteger(R.styleable.MdButton_mdb_type, 11);
            if (sButtonInfos.containsKey(type)) {
                defStyleAttr = sButtonInfos.get(type);
            }
        }
        finally {
            a.recycle();
        }
        return defStyleAttr;
    }

    public MdButton(Context context) {
        this(context, null);
    }

    public MdButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MdButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, MdButton.getDefaultStyleAttr(context, attrs, defStyleAttr));
        this.initFromAttributes(attrs, MdButton.getDefaultStyleAttr(context, attrs, defStyleAttr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        Context context = this.getContext();
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdButton, defStyleAttr, 0);
        try {
            this.mType = a.getInteger(R.styleable.MdButton_mdb_type, 11);
            this.mTextColorId = a.getResourceId(R.styleable.TextAppearance_android_textColor, 0);
        }
        finally {
            a.recycle();
        }
        if (Build.VERSION.SDK_INT < 23 && this.mTextColorId > 0) {
            try {
                this.setTextColor(ResourceUtils.createColorStateListFromResId(context, this.mTextColorId));
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        sButtonInfos.put(11, R.attr.MdButtonStyle);
        sButtonInfos.put(12, R.attr.MdButtonColoredStyle);
        sButtonInfos.put(13, R.attr.MdButtonBorderlessStyle);
        sButtonInfos.put(14, R.attr.MdButtonBorderlessColoredStyle);
    }
}

