/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.HashMap;
import java.util.Map;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.ResourceUtils;
import me.henrytao.mdcore.widgets.MdIcon;

public class MdListItem
extends RelativeLayout {
    protected static final int DEFAULT_TYPE = 11;
    protected static Map<Integer, ListItemInfo> sListItemInfos = new HashMap<Integer, ListItemInfo>();
    protected Drawable mAvatar;
    protected int mDividerLayout;
    protected Drawable mIcon;
    protected PorterDuff.Mode mIconTintMode;
    protected String mSubtitle;
    protected String mTitle;
    protected int mType;
    protected ImageView vAvatar;
    protected ImageView vIcon;
    protected TextView vSubtitle;
    protected TextView vTitle;

    protected static int getDefaultLayout(int type) {
        if (!sListItemInfos.containsKey(type)) {
            return MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)11)).mDefLayout;
        }
        return MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)type)).mDefLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getDefaultStyleAttr(Context context, AttributeSet attrs, int styleAttr) {
        if (styleAttr > 0) {
            return styleAttr;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdListItem, 0, 0);
        int defStyleAttr = MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)11)).mDefStyleAttr;
        try {
            int type = a.getInteger(R.styleable.MdListItem_mdli_type, 11);
            if (sListItemInfos.containsKey(type)) {
                defStyleAttr = MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)type)).mDefStyleAttr;
            }
        }
        finally {
            a.recycle();
        }
        return defStyleAttr;
    }

    public MdListItem(Context context) {
        this(context, null);
    }

    public MdListItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MdListItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, MdListItem.getDefaultStyleAttr(context, attrs, defStyleAttr));
        this.initFromAttributes(attrs, MdListItem.getDefaultStyleAttr(context, attrs, defStyleAttr));
    }

    @TargetApi(value=21)
    public MdListItem(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, MdListItem.getDefaultStyleAttr(context, attrs, defStyleAttr), defStyleRes);
        this.initFromAttributes(attrs, MdListItem.getDefaultStyleAttr(context, attrs, defStyleAttr));
    }

    protected void onFinishInflate() {
        int count = this.getChildCount();
        if (count == 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(MdListItem.getDefaultLayout(this.mType), (ViewGroup)this, true);
        }
        if (this.mDividerLayout > 0 && !this.isInEditMode()) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.mDividerLayout, (ViewGroup)this, true);
        }
        super.onFinishInflate();
        this.vTitle = (TextView)this.findViewById(16908308);
        this.vSubtitle = (TextView)this.findViewById(16908309);
        this.vAvatar = (ImageView)this.findViewById(16908295);
        this.vIcon = (ImageView)this.findViewById(16908296);
        this.setTitle(this.mTitle);
        this.setSubtitle(this.mSubtitle);
        this.setAvatar(this.mAvatar);
        this.setIcon(this.mIcon);
        this.setIconTintMode(this.mIconTintMode);
    }

    public void setAvatar(Drawable drawable) {
        if (this.vAvatar != null) {
            this.vAvatar.setImageDrawable(drawable);
        }
    }

    public void setAvatar(@DrawableRes int resId) {
        if (this.vAvatar != null) {
            this.vAvatar.setImageResource(resId);
        }
    }

    public void setIcon(Drawable drawable) {
        if (this.vIcon != null) {
            this.vIcon.setImageDrawable(drawable);
        }
    }

    public void setIcon(@DrawableRes int resId) {
        if (this.vIcon != null) {
            this.vIcon.setImageResource(resId);
        }
    }

    public void setIconTintMode(PorterDuff.Mode iconTintMode) {
        this.mIconTintMode = iconTintMode;
        if (this.vIcon != null && this.vIcon instanceof MdIcon) {
            ((MdIcon)this.vIcon).setImageTintMode(this.mIconTintMode);
        }
    }

    public void setSubtitle(@StringRes int resId) {
        if (this.vSubtitle != null) {
            this.vSubtitle.setText(resId);
        }
    }

    public void setSubtitle(CharSequence subtitle) {
        if (this.vSubtitle != null) {
            this.vSubtitle.setText(subtitle);
        }
    }

    public void setTitle(@StringRes int resId) {
        if (this.vTitle != null) {
            this.vTitle.setText(resId);
        }
    }

    public void setTitle(CharSequence title) {
        if (this.vTitle != null) {
            this.vTitle.setText(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        this.renderInEditMode(attrs);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.MdListItem, defStyleAttr, 0);
        try {
            this.mType = a.getInteger(R.styleable.MdListItem_mdli_type, 11);
            this.mDividerLayout = a.getResourceId(R.styleable.MdListItem_mdli_divider_layout, 0);
            this.mTitle = a.getString(R.styleable.MdListItem_mdli_title);
            this.mSubtitle = a.getString(R.styleable.MdListItem_mdli_subtitle);
            this.mAvatar = a.getDrawable(R.styleable.MdListItem_mdli_avatar);
            this.mIcon = a.getDrawable(R.styleable.MdListItem_mdli_icon);
            this.mIconTintMode = ResourceUtils.parseTintMode(a.getInt(R.styleable.MdListItem_mdli_icon_tintMode, -1), PorterDuff.Mode.SRC_IN);
        }
        finally {
            a.recycle();
        }
    }

    protected void renderInEditMode(AttributeSet attrs) {
        if (this.isInEditMode()) {
            // empty if block
        }
    }

    static {
        sListItemInfos.put(11, new ListItemInfo(R.attr.MdListItemSingleLineTextOnlyStyle, R.layout.mdli_single_line_text_only));
        sListItemInfos.put(12, new ListItemInfo(R.attr.MdListItemSingleLineIconWithTextStyle, R.layout.mdli_single_line_icon_with_text));
        sListItemInfos.put(13, new ListItemInfo(R.attr.MdListItemSingleLineAvatarWithTextStyle, R.layout.mdli_single_line_avatar_with_text));
        sListItemInfos.put(14, new ListItemInfo(R.attr.MdListItemSingleLineAvatarWithTextAndIconStyle, R.layout.mdli_single_line_avatar_with_text_and_icon));
        sListItemInfos.put(21, new ListItemInfo(R.attr.MdListItemTwoLineTextOnlyStyle, R.layout.mdli_two_line_text_only));
        sListItemInfos.put(22, new ListItemInfo(R.attr.MdListItemTwoLineIconWithTextStyle, R.layout.mdli_two_line_icon_with_text));
        sListItemInfos.put(23, new ListItemInfo(R.attr.MdListItemTwoLineAvatarWithTextStyle, R.layout.mdli_two_line_avatar_with_text));
        sListItemInfos.put(24, new ListItemInfo(R.attr.MdListItemTwoLineAvatarWithTextAndIconStyle, R.layout.mdli_two_line_avatar_with_text_and_icon));
        sListItemInfos.put(31, new ListItemInfo(R.attr.MdListItemThreeLineTextOnlyStyle, R.layout.mdli_three_line_text_only));
        sListItemInfos.put(32, new ListItemInfo(R.attr.MdListItemThreeLineIconWithTextStyle, R.layout.mdli_three_line_icon_with_text));
        sListItemInfos.put(33, new ListItemInfo(R.attr.MdListItemThreeLineAvatarWithTextStyle, R.layout.mdli_three_line_avatar_with_text));
        sListItemInfos.put(34, new ListItemInfo(R.attr.MdListItemThreeLineAvatarWithTextAndIconStyle, R.layout.mdli_three_line_avatar_with_text_and_icon));
    }

    protected static class ListItemInfo {
        public int mDefLayout;
        public int mDefStyleAttr;

        public ListItemInfo(int defStyleAttr, int defLayout) {
            this.mDefStyleAttr = defStyleAttr;
            this.mDefLayout = defLayout;
        }
    }
}

