/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v7.graphics.drawable.DrawableUtils;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import java.io.IOException;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class MdIcon
extends AppCompatImageView {
    private int mImageTintId;
    private ColorStateList mImageTintList;
    private PorterDuff.Mode mImageTintMode;

    public MdIcon(Context context) {
        this(context, null);
    }

    public MdIcon(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MdIconStyle);
    }

    public MdIcon(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFromAttributes(attrs, defStyleAttr);
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.invalidateImageTint();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.invalidateImageTint();
    }

    public void setImageTintList(ColorStateList tint) {
        this.mImageTintList = tint;
        this.invalidateImageTint();
    }

    public void setImageTintMode(PorterDuff.Mode tintMode) {
        this.mImageTintMode = tintMode;
        this.invalidateImageTint();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidateImageTint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        Context context = this.getContext();
        boolean enabled = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdIcon, defStyleAttr, 0);
        try {
            enabled = a.getBoolean(R.styleable.MdIcon_enabled, enabled);
            this.mImageTintId = a.getResourceId(R.styleable.MdIcon_tint, 0);
            this.mImageTintMode = DrawableUtils.parseTintMode((int)a.getInt(R.styleable.MdIcon_tintMode, -1), null);
        }
        finally {
            a.recycle();
        }
        if (this.mImageTintId > 0) {
            try {
                this.mImageTintList = ResourceUtils.createColorStateListFromResId(context, this.mImageTintId);
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setEnabled(enabled);
    }

    private void invalidateImageTint() {
        super.setImageDrawable(ResourceUtils.createDrawableTint(this.getDrawable(), this.getDrawableState(), this.mImageTintList, this.mImageTintMode));
    }
}

