/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.internal.widget.ViewUtils;
import android.support.v7.widget.AppCompatCheckBox;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import java.io.IOException;
import me.henrytao.mdcore.R;
import me.henrytao.mdcore.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class MdIconToggle
extends AppCompatCheckBox {
    private int mDrawablePadding;
    private int mPaddingBottom;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mPaddingTop;

    public MdIconToggle(Context context) {
        this(context, null);
    }

    public MdIconToggle(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MdIconToggleStyle);
    }

    public MdIconToggle(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFromAttributes(attrs, defStyleAttr > 0 ? defStyleAttr : R.attr.MdIconToggleStyle);
    }

    public void setButtonDrawable(Drawable buttonDrawable) {
        super.setButtonDrawable(buttonDrawable);
    }

    protected void onDraw(Canvas canvas) {
        if (this.isLayoutRtl()) {
            canvas.translate((float)(-this.mPaddingRight), 0.0f);
        } else {
            canvas.translate((float)this.mPaddingLeft, 0.0f);
        }
        super.onDraw(canvas);
        Drawable background = this.getBackground();
        if (Build.VERSION.SDK_INT >= 21 && background != null) {
            Rect bounds = background.getBounds();
            int size = Math.abs(bounds.bottom - bounds.top);
            int top = bounds.top;
            int bottom = bounds.bottom;
            int left = this.isLayoutRtl() ? this.getWidth() - size : 0;
            int right = this.isLayoutRtl() ? this.getWidth() : size;
            background.setHotspotBounds(left, top, right, bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromAttributes(AttributeSet attrs, int defStyleAttr) {
        Context context = this.getContext();
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingBottom = this.getPaddingBottom();
        this.mDrawablePadding = this.getCompoundDrawablePadding();
        this.invalidatePadding();
        this.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MdIconToggle.this.invalidatePadding();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        if (Build.VERSION.SDK_INT < 23) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CompoundButton, defStyleAttr, 0);
            int buttonTintId = 0;
            try {
                buttonTintId = a.getResourceId(R.styleable.CompoundButton_buttonTint, 0);
            }
            finally {
                a.recycle();
            }
            if (buttonTintId > 0) {
                try {
                    this.setSupportButtonTintList(ResourceUtils.createColorStateListFromResId(context, buttonTintId));
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void invalidatePadding() {
        if (this.isLayoutRtl()) {
            this.setPadding(this.mPaddingLeft + this.mPaddingRight, this.mPaddingTop, TextUtils.isEmpty((CharSequence)this.getText()) ? 0 : this.mDrawablePadding, this.mPaddingBottom);
        } else {
            this.setPadding(TextUtils.isEmpty((CharSequence)this.getText()) ? 0 : this.mDrawablePadding, this.mPaddingTop, this.mPaddingRight + this.mPaddingLeft, this.mPaddingBottom);
        }
    }

    private boolean isLayoutRtl() {
        return ViewUtils.isLayoutRtl((View)this);
    }
}

