/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.support.v4.graphics.ColorUtils;
import android.util.AttributeSet;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.Window;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ResourceUtils {
    public static ColorStateList createColorStateListFromResId(Context context, int resId) throws IOException, XmlPullParserException {
        int depth;
        int type;
        XmlResourceParser parser = context.getResources().getXml(resId);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        Resources r = context.getResources();
        int innerDepth = parser.getDepth() + 2;
        ArrayList<int[]> customStateList = new ArrayList<int[]>();
        ArrayList<Integer> customColorList = new ArrayList<Integer>();
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int color = 0;
            float alpha = 1.0f;
            int[] stateSpec = new int[numAttrs];
            block7: for (int i = 0; i < numAttrs; ++i) {
                int stateResId = attrs.getAttributeNameResource(i);
                switch (stateResId) {
                    case 16843173: {
                        int colorAttrId = attrs.getAttributeResourceValue(i, 0);
                        if (colorAttrId == 0) {
                            String colorAttrValue = attrs.getAttributeValue(i);
                            colorAttrId = Integer.valueOf(colorAttrValue.replace("?", ""));
                            color = ResourceUtils.getColorFromAttribute(context, colorAttrId);
                            continue block7;
                        }
                        color = r.getColor(colorAttrId);
                        continue block7;
                    }
                    case 16843551: {
                        try {
                            alpha = attrs.getAttributeFloatValue(i, 1.0f);
                        }
                        catch (Exception e) {
                            String alphaAttrValue = attrs.getAttributeValue(i);
                            alpha = ResourceUtils.getFloatFromAttribute(context, Integer.valueOf(alphaAttrValue.replace("?", "")));
                        }
                        continue block7;
                    }
                    default: {
                        stateSpec[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
                    }
                }
            }
            stateSpec = StateSet.trimStateSet((int[])stateSpec, (int)j);
            color = ResourceUtils.modulateColorAlpha(color, alpha);
            customColorList.add(color);
            customStateList.add(stateSpec);
        }
        int[] colors = new int[customColorList.size()];
        int[][] states = new int[customStateList.size()][];
        int n = states.length;
        for (int i = 0; i < n; ++i) {
            colors[i] = (Integer)customColorList.get(i);
            states[i] = (int[])customStateList.get(i);
        }
        return new ColorStateList((int[][])states, colors);
    }

    public static void enableTranslucentStatus(Activity activity) {
        Window window = activity.getWindow();
        window.setFlags(0x4000000, 0x4000000);
        if (Build.VERSION.SDK_INT >= 21) {
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
        }
    }

    public static int getActionBarSize(Context context) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{16843499});
        int size = (int)a.getDimension(0, 0.0f);
        a.recycle();
        return size;
    }

    public static int getColorFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return 0;
        }
        TypedValue a = new TypedValue();
        context.getTheme().resolveAttribute(attrId, a, true);
        return context.getResources().getColor(a.resourceId);
    }

    public static float getFloatFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return 0.0f;
        }
        TypedValue a = new TypedValue();
        context.getTheme().resolveAttribute(attrId, a, true);
        return a.getFloat();
    }

    public static int getStatusBarSize(Context context) {
        int id;
        int statusBarSize = 0;
        if (context != null && (id = context.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
            statusBarSize = context.getResources().getDimensionPixelSize(id);
        }
        return statusBarSize;
    }

    private static int modulateColorAlpha(int baseColor, float alphaMod) {
        if (alphaMod == 1.0f) {
            return baseColor;
        }
        int alpha = Math.min(Math.max((int)(alphaMod * 255.0f), 0), 255);
        return ColorUtils.setAlphaComponent((int)baseColor, (int)alpha);
    }
}

