/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widgets;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.HashMap;
import java.util.Map;
import me.henrytao.mdcore.R;

public class MdListItem
extends RelativeLayout {
    protected static final int DEFAULT_TYPE = 11;
    protected static Map<Integer, ListItemInfo> sListItemInfos = new HashMap<Integer, ListItemInfo>();
    protected Drawable mAvatar;
    protected Drawable mIcon;
    protected String mSubtitle;
    protected String mTitle;
    protected int mType;
    protected ImageView vAvatar;
    protected ImageView vIcon;
    protected TextView vSubtitle;
    protected TextView vTitle;

    protected static int getDefaultLayout(int type) {
        if (!sListItemInfos.containsKey(type)) {
            return MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)11)).mDefLayout;
        }
        return MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)type)).mDefLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getDefaultStyleAttr(Context context, AttributeSet attrs, int styleAttr) {
        if (styleAttr > 0) {
            return styleAttr;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdListItem, 0, 0);
        int defStyleAttr = MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)11)).mDefStyleAttr;
        try {
            int type = a.getInteger(R.styleable.MdListItem_mdli_type, 11);
            if (sListItemInfos.containsKey(type)) {
                defStyleAttr = MdListItem.sListItemInfos.get((Object)Integer.valueOf((int)type)).mDefStyleAttr;
            }
        }
        finally {
            a.recycle();
        }
        return defStyleAttr;
    }

    public MdListItem(Context context) {
        this(context, null);
    }

    public MdListItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MdListItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, MdListItem.getDefaultStyleAttr(context, attrs, defStyleAttr));
        this.initFromAttributes(attrs);
    }

    @TargetApi(value=21)
    public MdListItem(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, MdListItem.getDefaultStyleAttr(context, attrs, defStyleAttr), defStyleRes);
        this.initFromAttributes(attrs);
    }

    protected void onFinishInflate() {
        int count = this.getChildCount();
        if (count == 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(MdListItem.getDefaultLayout(this.mType), (ViewGroup)this, true);
        }
        super.onFinishInflate();
        this.vTitle = (TextView)this.findViewById(16908308);
        this.vSubtitle = (TextView)this.findViewById(16908309);
        this.vAvatar = (ImageView)this.findViewById(16908295);
        this.vIcon = (ImageView)this.findViewById(16908296);
        this.setTitle(this.mTitle);
        this.setSubtitle(this.mSubtitle);
        this.setAvatar(this.mAvatar);
        this.setIcon(this.mIcon);
    }

    public void setAvatar(Drawable drawable) {
        if (this.vAvatar != null) {
            this.vAvatar.setImageDrawable(drawable);
        }
    }

    public void setAvatar(@DrawableRes int resId) {
        if (this.vAvatar != null) {
            this.vAvatar.setImageResource(resId);
        }
    }

    public void setIcon(Drawable drawable) {
        if (this.vIcon != null) {
            this.vIcon.setImageDrawable(drawable);
        }
    }

    public void setIcon(@DrawableRes int resId) {
        if (this.vIcon != null) {
            this.vIcon.setImageResource(resId);
        }
    }

    public void setSubtitle(@StringRes int resId) {
        if (this.vSubtitle != null) {
            this.vSubtitle.setText(resId);
        }
    }

    public void setSubtitle(CharSequence subtitle) {
        if (this.vSubtitle != null) {
            this.vSubtitle.setText(subtitle);
        }
    }

    public void setTitle(@StringRes int resId) {
        if (this.vTitle != null) {
            this.vTitle.setText(resId);
        }
    }

    public void setTitle(CharSequence title) {
        if (this.vTitle != null) {
            this.vTitle.setText(title);
        }
    }

    protected void initFromAttributes(AttributeSet attrs) {
        this.renderInEditMode(attrs);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.MdListItem, 0, 0);
        try {
            this.mType = a.getInteger(R.styleable.MdListItem_mdli_type, 11);
            this.mTitle = a.getString(R.styleable.MdListItem_mdli_title);
            this.mSubtitle = a.getString(R.styleable.MdListItem_mdli_subtitle);
            this.mAvatar = a.getDrawable(R.styleable.MdListItem_mdli_avatar);
            this.mIcon = a.getDrawable(R.styleable.MdListItem_mdli_icon);
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderInEditMode(AttributeSet attrs) {
        if (this.isInEditMode()) {
            int[] attributes = new int[]{0x1010140};
            TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, attributes, 0, 0);
            try {
                this.setMinimumHeight(a.getDimensionPixelSize(0, 0));
            }
            finally {
                a.recycle();
            }
        }
    }

    static {
        sListItemInfos.put(11, new ListItemInfo(R.attr.MdListItemSingleLineTextOnly, R.layout.mdli_single_line_text_only));
        sListItemInfos.put(12, new ListItemInfo(R.attr.MdListItemSingleLineIconWithText, R.layout.mdli_single_line_icon_with_text));
        sListItemInfos.put(13, new ListItemInfo(R.attr.MdListItemSingleLineAvatarWithText, R.layout.mdli_single_line_avatar_with_text));
        sListItemInfos.put(14, new ListItemInfo(R.attr.MdListItemSingleLineAvatarWithTextAndIcon, R.layout.mdli_single_line_avatar_with_text_and_icon));
        sListItemInfos.put(21, new ListItemInfo(R.attr.MdListItemTwoLineTextOnly, R.layout.mdli_two_line_text_only));
        sListItemInfos.put(22, new ListItemInfo(R.attr.MdListItemTwoLineIconWithText, R.layout.mdli_two_line_icon_with_text));
        sListItemInfos.put(23, new ListItemInfo(R.attr.MdListItemTwoLineAvatarWithText, R.layout.mdli_two_line_avatar_with_text));
        sListItemInfos.put(24, new ListItemInfo(R.attr.MdListItemTwoLineAvatarWithTextAndIcon, R.layout.mdli_two_line_avatar_with_text_and_icon));
        sListItemInfos.put(31, new ListItemInfo(R.attr.MdListItemThreeLineTextOnly, R.layout.mdli_three_line_text_only));
        sListItemInfos.put(32, new ListItemInfo(R.attr.MdListItemThreeLineIconWithText, R.layout.mdli_three_line_icon_with_text));
        sListItemInfos.put(33, new ListItemInfo(R.attr.MdListItemThreeLineAvatarWithText, R.layout.mdli_three_line_avatar_with_text));
        sListItemInfos.put(34, new ListItemInfo(R.attr.MdListItemThreeLineAvatarWithTextAndIcon, R.layout.mdli_three_line_avatar_with_text_and_icon));
    }

    protected static class ListItemInfo {
        public int mDefLayout;
        public int mDefStyleAttr;

        public ListItemInfo(int defStyleAttr, int defLayout) {
            this.mDefStyleAttr = defStyleAttr;
            this.mDefLayout = defLayout;
        }
    }
}

