/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import me.henrytao.mdcore.R;

public class RoundClippingLinearLayout
extends LinearLayout {
    private int mBackgroundColor;
    private RectF mBounds;
    private int mCornerRadius;
    private Paint mDrawPaint;

    public RoundClippingLinearLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundClippingLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=11)
    public RoundClippingLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public RoundClippingLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.drawRoundRect(this.mBounds, (float)this.mCornerRadius, (float)this.mCornerRadius, this.mDrawPaint);
        super.dispatchDraw(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw && h != oldh) {
            this.mBounds = new RectF(0.0f, 0.0f, (float)w, (float)h);
        }
    }

    protected void init(Context context, AttributeSet attrs) {
        this.mBackgroundColor = 0;
        this.mCornerRadius = 0;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundClippingLinearLayout, 0, 0);
            this.mBackgroundColor = a.getColor(R.styleable.RoundClippingLinearLayout_md_background_color, 0);
            this.mCornerRadius = a.getDimensionPixelSize(R.styleable.RoundClippingLinearLayout_md_corner_radius, 0);
            a.recycle();
        }
        this.mBounds = new RectF();
        this.mBounds.set(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        this.mDrawPaint = new Paint(1);
        this.mDrawPaint.setColor(this.mBackgroundColor);
        this.mDrawPaint.setStyle(Paint.Style.FILL);
    }
}

