/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import me.henrytao.mdcore.R;

public class MdButton
extends AppCompatButton {
    private static final float sDisableAlpha = 0.54f;
    private float mDisableAlpha;

    public MdButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MdButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MdButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setDisableAlpha(enabled);
    }

    protected void init(Context context, AttributeSet attrs) {
        this.mDisableAlpha = 0.54f;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MdButton, 0, 0);
            this.mDisableAlpha = a.getFloat(R.styleable.MdButton_md_disable_alpha, 0.54f);
            a.recycle();
        }
        this.setDisableAlpha(this.isEnabled());
    }

    protected void setDisableAlpha(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setAlpha(enabled ? 1.0f : this.mDisableAlpha);
        }
    }
}

