/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.mdcore.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class ResourceUtils {
    public static void closeKeyBoard(Activity activity) {
        ResourceUtils.closeKeyBoard((Context)activity, activity.getCurrentFocus());
    }

    public static void closeKeyBoard(Context context, View view) {
        if (view != null) {
            ((InputMethodManager)context.getSystemService("input_method")).hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    public static int getColorFromAttribute(Activity activity, int attrId) {
        if (attrId == 0) {
            return 0;
        }
        TypedValue typedValue = new TypedValue();
        activity.getTheme().resolveAttribute(attrId, typedValue, true);
        return typedValue.data;
    }

    public static int getDimensionPixelSizeFromAttribute(Activity activity, int attrId) {
        if (attrId == 0) {
            return 0;
        }
        TypedValue typedValue = new TypedValue();
        activity.getTheme().resolveAttribute(attrId, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public static int getDrawableIdFromAttribute(Context context, int attrId) {
        if (attrId == 0) {
            return 0;
        }
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrId, typedValue, true);
        return typedValue.resourceId;
    }

    public static View inflate(Activity activity, int layoutResId) {
        return ResourceUtils.inflate(activity, layoutResId, null, false);
    }

    public static View inflate(Activity activity, int layoutResId, ViewGroup parent) {
        return ResourceUtils.inflate(activity, layoutResId, parent, false);
    }

    public static View inflate(Activity activity, int layoutResId, ViewGroup root, boolean attachToRoot) {
        return activity.getLayoutInflater().inflate(layoutResId, root, attachToRoot);
    }

    public static void moveCursorToTheEnd(EditText editText) {
        int length = editText.getText().length();
        editText.setSelection(length, length);
    }

    public static void showKeyboard(Context context, EditText editText) {
        editText.requestFocus();
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInput((View)editText, 1);
    }
}

