/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.model.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BillFields {
    private static final List<String> START_FIELDS = Arrays.asList("trade_time", "appid", "mch_id", "sub_mch_id", "device_info", "transaction_id", "out_trade_no", "openid", "trade_type", "trade_state", "bank_type", "fee_type", "total_fee", "enter_ed_pkg_fee");
    private static final List<String> END_FIELDS = Arrays.asList("body", "data_pkg", "commission_fee", "fee_rate");
    public static final List<String> ALL = BillFields.initAllFields();
    public static final List<String> REFUND = BillFields.initRefundFields();
    public static final List<String> SUCCESS = BillFields.initSuccessFields();
    public static final List<String> COUNT = Arrays.asList("trade_total_count", "trade_total_fee", "refund_total_fee", "coupon_refund_total_fee", "commission_total_fee");

    private BillFields() {
    }

    private static List<String> initAllFields() {
        ArrayList<String> all = new ArrayList<String>();
        BillFields.startFields(all);
        BillFields.initCommonRefundFields(all);
        BillFields.endFields(all);
        return all;
    }

    private static List<String> initRefundFields() {
        ArrayList<String> refund = new ArrayList<String>();
        BillFields.startFields(refund);
        refund.add("refund_apply_time");
        refund.add("refund_success_time");
        BillFields.initCommonRefundFields(refund);
        BillFields.endFields(refund);
        return refund;
    }

    private static void initCommonRefundFields(List<String> fields) {
        fields.add("refund_id");
        fields.add("out_refund_no");
        fields.add("refund_fee");
        fields.add("enter_red_pkg_refund_fee");
        fields.add("refund_channel");
        fields.add("refund_status");
    }

    private static List<String> initSuccessFields() {
        ArrayList<String> success = new ArrayList<String>();
        BillFields.startFields(success);
        BillFields.endFields(success);
        return success;
    }

    private static void startFields(List<String> fields) {
        for (String f : START_FIELDS) {
            fields.add(f);
        }
    }

    private static void endFields(List<String> fields) {
        for (String f : END_FIELDS) {
            fields.add(f);
        }
    }
}

