/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import me.hao0.common.util.Strings;
import me.hao0.wepay.core.Bills;
import me.hao0.wepay.core.Notifies;
import me.hao0.wepay.core.Orders;
import me.hao0.wepay.core.Pays;
import me.hao0.wepay.core.Refunds;
import me.hao0.wepay.exception.WepayException;

public final class Wepay {
    private final String appId;
    private final String appKey;
    private final String mchId;
    byte[] certs;
    String certPasswd;
    String respEncode = "UTF-8";
    private SSLSocketFactory sslSocketFactory;
    private Pays pays;
    private Orders orders;
    private Refunds refunds;
    private Notifies notifies;
    private Bills bills;

    Wepay(String appId, String appKey, String mchId) {
        this.appId = appId;
        this.appKey = appKey;
        this.mchId = mchId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getMchId() {
        return this.mchId;
    }

    public byte[] getCerts() {
        return this.certs;
    }

    public String getCertPasswd() {
        return this.certPasswd;
    }

    public String getRespEncode() {
        return this.respEncode;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public Wepay init() {
        this.pays = new Pays(this);
        this.orders = new Orders(this);
        this.refunds = new Refunds(this);
        this.notifies = new Notifies(this);
        this.bills = new Bills(this);
        if (this.certs != null && !Strings.isNullOrEmpty((String)this.certPasswd).booleanValue()) {
            this.sslSocketFactory = this.initSSLSocketFactory();
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLSocketFactory initSSLSocketFactory() {
        try (ByteArrayInputStream certsInput = new ByteArrayInputStream(this.certs);){
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certsInput, this.certPasswd.toCharArray());
            ((InputStream)certsInput).close();
            keyManagerFactory.init(keyStore, this.certPasswd.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = context.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (Exception e) {
            throw new WepayException(e);
        }
    }

    public Pays pay() {
        return this.pays;
    }

    public Orders order() {
        return this.orders;
    }

    public Refunds refund() {
        return this.refunds;
    }

    public Notifies notifies() {
        return this.notifies;
    }

    public Bills bill() {
        return this.bills;
    }
}

