/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import me.hao0.common.util.Preconditions;
import me.hao0.common.util.Strings;
import me.hao0.wepay.core.Component;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.model.common.Coupon;
import me.hao0.wepay.model.enums.FeeType;
import me.hao0.wepay.model.enums.RefundChannel;
import me.hao0.wepay.model.enums.RefundStatus;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import me.hao0.wepay.model.refund.RefundItem;
import me.hao0.wepay.model.refund.RefundQueryResponse;
import me.hao0.wepay.util.RandomStrs;

public final class Refunds
extends Component {
    private static final String APPLY = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private static final String QUERY = "https://api.mch.weixin.qq.com/pay/refundquery";

    Refunds(Wepay wepay) {
        super(wepay);
    }

    public RefundApplyResponse apply(RefundApplyRequest request) {
        this.checkApplyParams(request);
        Map<String, String> applyParams = this.buildApplyParams(request);
        return this.doHttpsPost(APPLY, applyParams, RefundApplyResponse.class);
    }

    public RefundQueryResponse queryByOutTradeNo(String outTradeNo) {
        Map<String, String> queryParams = this.buildQueryParams("out_trade_no", outTradeNo);
        Map<String, Object> respData = this.doPost(QUERY, queryParams);
        return this.renderQueryResp(respData);
    }

    public RefundQueryResponse queryByOutRefundNo(String outRefundNo) {
        Map<String, String> queryParams = this.buildQueryParams("out_refund_no", outRefundNo);
        Map<String, Object> respData = this.doPost(QUERY, queryParams);
        return this.renderQueryResp(respData);
    }

    public RefundQueryResponse queryByTransactionId(String transactionId) {
        Map<String, String> queryParams = this.buildQueryParams("transaction_id", transactionId);
        Map<String, Object> respData = this.doPost(QUERY, queryParams);
        return this.renderQueryResp(respData);
    }

    public RefundQueryResponse queryByRefundId(String refundId) {
        Map<String, String> queryParams = this.buildQueryParams("refund_id", refundId);
        Map<String, Object> respData = this.doPost(QUERY, queryParams);
        return this.renderQueryResp(respData);
    }

    private RefundQueryResponse renderQueryResp(Map<String, Object> refundData) {
        RefundQueryResponse queryResp = new RefundQueryResponse();
        queryResp.setOutTradeNo((String)refundData.get("out_trade_no"));
        queryResp.setTransactionId((String)refundData.get("transaction_id"));
        queryResp.setTotalFee(Integer.parseInt((String)refundData.get("total_fee")));
        queryResp.setCashFee(Integer.parseInt((String)refundData.get("cash_fee")));
        String feeType = (String)refundData.get("fee_type");
        if (!Strings.isNullOrEmpty((String)feeType).booleanValue()) {
            queryResp.setFeeType(FeeType.from(feeType));
        }
        Integer refundCount = Integer.parseInt((String)refundData.get("refund_count"));
        ArrayList<RefundItem> refundItems = new ArrayList<RefundItem>();
        for (int refundIndex = 0; refundIndex < refundCount; ++refundIndex) {
            RefundItem refundItem = this.renderRefundItem(refundData, refundIndex);
            refundItems.add(refundItem);
        }
        queryResp.setItems(refundItems);
        return queryResp;
    }

    private RefundItem renderRefundItem(Map<String, Object> refundData, int refundItemIndex) {
        Integer couponRefundCount;
        Object couponRefundCountObj;
        RefundItem refundItem = new RefundItem();
        refundItem.setOutRefundNo((String)refundData.get("out_refund_no_" + refundItemIndex));
        refundItem.setRefundId((String)refundData.get("refund_id_" + refundItemIndex));
        refundItem.setChannel(RefundChannel.from((String)refundData.get("refund_channel_" + refundItemIndex)));
        refundItem.setRefundFee(Integer.parseInt((String)refundData.get("refund_fee_" + refundItemIndex)));
        refundItem.setRefundStatus(RefundStatus.from((String)refundData.get("refund_status_" + refundItemIndex)));
        String settlementRefundFee = (String)refundData.get("settlement_refund_fee_" + refundItemIndex);
        if (!Strings.isNullOrEmpty((String)settlementRefundFee).booleanValue()) {
            refundItem.setSettlementRefundFee(Integer.parseInt(settlementRefundFee));
        }
        refundItem.setRefundRecvAccout((String)refundData.get("refund_recv_accout_" + refundItemIndex));
        Object couponRefundFee = refundData.get("coupon_refund_fee_" + refundItemIndex);
        if (couponRefundFee != null) {
            refundItem.setCouponRefundFee(Integer.parseInt((String)couponRefundFee));
        }
        if ((couponRefundCountObj = refundData.get("coupon_refund_count_" + refundItemIndex)) != null && (couponRefundCount = Integer.valueOf(Integer.parseInt((String)couponRefundCountObj))) > 0) {
            ArrayList<Coupon> couponItems = new ArrayList<Coupon>();
            for (int couponItemIndex = 0; couponItemIndex < couponRefundCount; ++couponItemIndex) {
                Coupon couponItem = Coupon.newCoupon((String)refundData.get("coupon_refund_batch_id_" + refundItemIndex + "_" + couponItemIndex), (String)refundData.get("coupon_refund_id_" + refundItemIndex + "_" + couponItemIndex), Integer.parseInt((String)refundData.get("coupon_refund_fee_" + refundItemIndex + "_" + couponItemIndex)));
                couponItems.add(couponItem);
            }
            refundItem.setCoupons(couponItems);
        }
        return refundItem;
    }

    private Map<String, String> buildQueryParams(String queryFieldName, String queryFieldValue) {
        Preconditions.checkNotNullAndEmpty((String)queryFieldValue, (String)queryFieldName);
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        this.buildConfigParams(queryParams);
        queryParams.put("nonce_str", RandomStrs.generate(16));
        queryParams.put(queryFieldName, queryFieldValue);
        this.buildSignParams(queryParams);
        return queryParams;
    }

    private void checkApplyParams(RefundApplyRequest request) {
        Preconditions.checkNotNull((Object)this.wepay.certs, (Object)"merchant certs can't be null before apply refund");
        Preconditions.checkNotNullAndEmpty((String)this.wepay.certPasswd, (String)"certPasswd");
        Preconditions.checkNotNull((Object)request, (Object)"apply request can't be null");
        if (Strings.isNullOrEmpty((String)request.getTransactionId()).booleanValue()) {
            Preconditions.checkNotNullAndEmpty((String)request.getOutTradeNo(), (String)"transactionId && outTradeNo");
        }
        Preconditions.checkNotNullAndEmpty((String)request.getOutRefundNo(), (String)"outRefundNo");
        Preconditions.checkNotNullAndEmpty((String)request.getOpUserId(), (String)"opUserId");
        Integer totalFee = request.getTotalFee();
        Integer refundFee = request.getRefundFee();
        Preconditions.checkPositive((Number)totalFee, (String)"totalFee");
        Preconditions.checkPositive((Number)refundFee, (String)"refundFee");
        Preconditions.checkPositive((Number)(totalFee - refundFee), (String)"totalFee - refundFee");
    }

    private Map<String, String> buildApplyParams(RefundApplyRequest request) {
        TreeMap<String, String> refundParams = new TreeMap<String, String>();
        this.buildConfigParams(refundParams);
        this.putIfNotEmpty(refundParams, "transaction_id", request.getTransactionId());
        this.putIfNotEmpty(refundParams, "out_trade_no", request.getOutTradeNo());
        this.put(refundParams, "out_refund_no", request.getOutRefundNo());
        this.put(refundParams, "total_fee", request.getTotalFee() + "");
        this.put(refundParams, "refund_fee", request.getRefundFee() + "");
        this.put(refundParams, "nonce_str", RandomStrs.generate(16));
        this.put(refundParams, "op_user_id", request.getOpUserId());
        this.putIfNotEmpty(refundParams, "device_info", request.getDeviceInfo());
        if (request.getRefundFeeType() != null) {
            this.put(refundParams, "refund_fee_type", request.getRefundFeeType().type());
        }
        this.buildSignParams(refundParams);
        return refundParams;
    }
}

