/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import me.hao0.common.date.Dates;
import me.hao0.common.security.MD5;
import me.hao0.common.util.Preconditions;
import me.hao0.wepay.core.Component;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.TradeType;
import me.hao0.wepay.model.pay.AppPayResponse;
import me.hao0.wepay.model.pay.JsPayRequest;
import me.hao0.wepay.model.pay.JsPayResponse;
import me.hao0.wepay.model.pay.PayRequest;
import me.hao0.wepay.model.pay.QrPayRequest;
import me.hao0.wepay.model.pay.QrPayResponse;
import me.hao0.wepay.util.RandomStrs;

public final class Pays
extends Component {
    private static final String PAY_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String LIANTU_URL = "http://qr.liantu.com/api.php?text=";

    protected Pays(Wepay wepay) {
        super(wepay);
    }

    public JsPayResponse jsPay(JsPayRequest request) {
        this.checkJsPayParams(request);
        Map<String, Object> respData = this.doJsPay(request, TradeType.JSAPI);
        return this.buildJsPayResp(respData);
    }

    public QrPayResponse qrPay(QrPayRequest request) {
        return this.qrPay(request, Boolean.TRUE);
    }

    public QrPayResponse qrPay(QrPayRequest request, Boolean convert) {
        this.checkPayParams(request);
        Map<String, Object> respData = this.doQrPay(request, TradeType.NATIVE);
        String codeUrl = String.valueOf(respData.get("code_url"));
        if (convert.booleanValue()) {
            try {
                codeUrl = LIANTU_URL + URLEncoder.encode(codeUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WepayException(e);
            }
        }
        String prepayId = String.valueOf(respData.get("prepay_id"));
        QrPayResponse resp = new QrPayResponse();
        resp.setCodeUrl(codeUrl);
        resp.setPrepayId(prepayId);
        return resp;
    }

    public AppPayResponse appPay(PayRequest request) {
        this.checkPayParams(request);
        Map<String, Object> respData = this.doAppPay(request, TradeType.APP);
        return this.buildAppPayResp(respData);
    }

    private Map<String, Object> doJsPay(JsPayRequest request, TradeType tradeType) {
        Map<String, String> payParams = this.buildPayParams(request, tradeType);
        payParams.put("openid", request.getOpenId());
        return this.doPay(payParams);
    }

    private Map<String, Object> doAppPay(PayRequest request, TradeType tradeType) {
        Map<String, String> payParams = this.buildPayParams(request, tradeType);
        return this.doPay(payParams);
    }

    private Map<String, Object> doQrPay(QrPayRequest request, TradeType tradeType) {
        Map<String, String> payParams = this.buildPayParams(request, tradeType);
        this.putIfNotEmpty(payParams, "product_id", request.getProductId());
        return this.doPay(payParams);
    }

    private Map<String, Object> doPay(Map<String, String> payParams) {
        this.buildSignParams(payParams);
        return this.doPost(PAY_URL, payParams);
    }

    private JsPayResponse buildJsPayResp(Map<String, Object> data) {
        String appId = this.wepay.getAppId();
        String nonceStr = RandomStrs.generate(16);
        String timeStamp = String.valueOf(Dates.now().getTime() / 1000L);
        String pkg = "prepay_id=" + data.get("prepay_id");
        String signing = "appId=" + appId + "&" + "nonceStr" + "=" + nonceStr + "&" + "package" + "=" + pkg + "&" + "signType" + "=MD5" + "&" + "timeStamp" + "=" + timeStamp + "&" + "key" + "=" + this.wepay.getAppKey();
        String signed = MD5.generate((String)signing, (boolean)false).toUpperCase();
        return new JsPayResponse(appId, timeStamp, nonceStr, pkg, "MD5", signed);
    }

    private AppPayResponse buildAppPayResp(Map<String, Object> data) {
        String appId = this.wepay.getAppId();
        String partnerId = this.wepay.getMchId();
        String nonceStr = RandomStrs.generate(16);
        String timeStamp = String.valueOf(Dates.now().getTime() / 1000L);
        String prepayId = String.valueOf(data.get("prepay_id"));
        String signing = "appid=" + appId + "&" + "noncestr" + "=" + nonceStr + "&" + "package" + "=Sign=WXPay" + "&" + "partnerid" + "=" + partnerId + "&" + "prepayid" + "=" + prepayId + "&" + "timestamp" + "=" + timeStamp + "&" + "key" + "=" + this.wepay.getAppKey();
        String signed = MD5.generate((String)signing, (boolean)false).toUpperCase();
        return new AppPayResponse(appId, partnerId, prepayId, timeStamp, nonceStr, signed);
    }

    private void checkJsPayParams(JsPayRequest request) {
        this.checkPayParams(request);
        Preconditions.checkNotNullAndEmpty((String)request.getOpenId(), (String)"openId");
    }

    private void checkPayParams(PayRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"pay detail can't be null");
        Preconditions.checkNotNullAndEmpty((String)request.getBody(), (String)"body");
        Preconditions.checkNotNullAndEmpty((String)request.getOutTradeNo(), (String)"outTradeNo");
        Integer totalFee = request.getTotalFee();
        Preconditions.checkArgument((totalFee != null && totalFee > 0 ? 1 : 0) != 0, (Object)"totalFee must > 0");
        Preconditions.checkNotNullAndEmpty((String)request.getClientIp(), (String)"clientId");
        Preconditions.checkNotNullAndEmpty((String)request.getNotifyUrl(), (String)"notifyUrl");
        Preconditions.checkNotNull((Object)((Object)request.getFeeType()), (Object)"feeType can't be null");
        Preconditions.checkNotNullAndEmpty((String)request.getTimeStart(), (String)"timeStart");
    }

    private Map<String, String> buildPayParams(PayRequest request, TradeType tradeType) {
        TreeMap<String, String> payParams = new TreeMap<String, String>();
        this.buildConfigParams(payParams);
        this.put(payParams, "body", request.getBody());
        this.put(payParams, "out_trade_no", request.getOutTradeNo());
        this.put(payParams, "total_fee", request.getTotalFee() + "");
        this.put(payParams, "spbill_create_ip", request.getClientIp());
        this.put(payParams, "notify_url", request.getNotifyUrl());
        this.put(payParams, "fee_type", request.getFeeType().type());
        this.put(payParams, "nonce_str", RandomStrs.generate(16));
        this.put(payParams, "time_start", request.getTimeStart());
        this.put(payParams, "trade_type", tradeType.type());
        this.putIfNotEmpty(payParams, "device_info", request.getDeviceInfo());
        this.putIfNotEmpty(payParams, "attach", request.getAttach());
        this.putIfNotEmpty(payParams, "detail", request.getDetail());
        this.putIfNotEmpty(payParams, "goods_tag", request.getGoodsTag());
        this.putIfNotEmpty(payParams, "time_expire", request.getTimeExpire());
        this.putIfNotEmpty(payParams, "limit_pay", request.getLimitPay());
        return payParams;
    }
}

