/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.wepay.core.Component;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.model.common.Coupon;
import me.hao0.wepay.model.order.WePayOrder;
import me.hao0.wepay.util.RandomStrs;

public final class Orders
extends Component {
    private static final String ORDER_QUERY = "https://api.mch.weixin.qq.com/pay/orderquery";
    private static final String ORDER_CLOSE = "https://api.mch.weixin.qq.com/pay/closeorder";

    Orders(Wepay wepay) {
        super(wepay);
    }

    public WePayOrder queryByTransactionId(String transactionId) {
        Preconditions.checkNotNullAndEmpty((String)transactionId, (String)"transactionId");
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        this.put(queryParams, "transaction_id", transactionId);
        return this.doQueryOrder(queryParams);
    }

    public WePayOrder queryByOutTradeNo(String outTradeNo) {
        Preconditions.checkNotNullAndEmpty((String)outTradeNo, (String)"outTradeNo");
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        this.put(queryParams, "out_trade_no", outTradeNo);
        return this.doQueryOrder(queryParams);
    }

    private WePayOrder doQueryOrder(Map<String, String> queryParams) {
        this.buildQueryParams(queryParams);
        Map<String, Object> orderData = this.doPost(ORDER_QUERY, queryParams);
        WePayOrder order = (WePayOrder)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(orderData), WePayOrder.class);
        this.setCoupons(order, orderData);
        return order;
    }

    private void setCoupons(WePayOrder order, Map<String, Object> orderData) {
        if (order != null && order.getCouponCount() != null && order.getCouponCount() > 0) {
            ArrayList<Coupon> coupons = new ArrayList<Coupon>();
            for (int couponIndex = 0; couponIndex < order.getCouponCount(); ++couponIndex) {
                Coupon coupon = Coupon.newCoupon((String)orderData.get("coupon_batch_id_" + couponIndex), (String)orderData.get("coupon_id_" + couponIndex), Integer.parseInt((String)orderData.get("coupon_fee_" + couponIndex)));
                coupons.add(coupon);
            }
            order.setCoupons(coupons);
        }
    }

    public Boolean closeOrder(String outTradeNo) {
        Preconditions.checkNotNullAndEmpty((String)outTradeNo, (String)"outTradeNo");
        TreeMap<String, String> closeParams = new TreeMap<String, String>();
        this.put(closeParams, "out_trade_no", outTradeNo);
        this.buildCloseParams(closeParams);
        return this.doPost(ORDER_CLOSE, closeParams) != null;
    }

    private void buildCloseParams(Map<String, String> closeParams) {
        this.buildConfigParams(closeParams);
        this.put(closeParams, "nonce_str", RandomStrs.generate(16));
        this.buildSignParams(closeParams);
    }

    private void buildQueryParams(Map<String, String> queryParams) {
        this.buildConfigParams(queryParams);
        this.put(queryParams, "nonce_str", RandomStrs.generate(16));
        this.buildSignParams(queryParams);
    }
}

