/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.core;

import java.util.Map;
import java.util.TreeMap;
import me.hao0.common.http.Http;
import me.hao0.common.http.Https;
import me.hao0.common.json.Jsons;
import me.hao0.common.security.MD5;
import me.hao0.common.util.Strings;
import me.hao0.common.xml.XmlReaders;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.SignException;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.util.Maps;

public abstract class Component {
    protected Wepay wepay;

    protected Component(Wepay wepay) {
        this.wepay = wepay;
    }

    protected Map<String, Object> doPost(String url, Map<String, String> params) {
        String requestBody = Maps.toXml(params);
        String resp = Http.post((String)url).ssl().body(requestBody).request();
        Map<String, Object> respMap = this.toMap(resp.replaceAll("(\\r|\\n)", ""));
        if (!this.doVerifySign(respMap).booleanValue()) {
            throw new SignException("\u5fae\u4fe1\u54cd\u5e94\u5185\u5bb9\u7b7e\u540d\u975e\u6cd5: " + respMap);
        }
        return respMap;
    }

    protected <T> T doHttpsPost(String url, Map<String, String> params, Class<T> respClazz) {
        String requestBody = Maps.toXml(params);
        String resp = Https.post((String)url).body(requestBody).ssLSocketFactory(this.wepay.getSslSocketFactory()).request();
        Map<String, Object> respMap = this.toMap(resp.replaceAll("(\\r|\\n)", ""));
        if (!this.doVerifySign(respMap).booleanValue()) {
            throw new SignException("\u5fae\u4fe1\u54cd\u5e94\u5185\u5bb9\u7b7e\u540d\u975e\u6cd5: " + respMap);
        }
        return (T)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(respMap), respClazz);
    }

    protected Map<String, Object> toMap(String xml) {
        XmlReaders readers = this.readResp(xml);
        return Maps.toMap(readers);
    }

    private XmlReaders readResp(String xml) {
        XmlReaders readers = XmlReaders.create((String)xml, (String)this.wepay.respEncode);
        String returnCode = readers.getNodeStr("return_code");
        if ("SUCCESS".equals(returnCode)) {
            String resultCode = readers.getNodeStr("result_code");
            if ("SUCCESS".equals(resultCode)) {
                return readers;
            }
            throw new WepayException(readers.getNodeStr("err_code"), readers.getNodeStr("err_code_des"));
        }
        throw new WepayException(readers.getNodeStr("return_code"), readers.getNodeStr("return_msg"));
    }

    protected void buildConfigParams(Map<String, String> params) {
        params.put("appid", this.wepay.getAppId());
        params.put("mch_id", this.wepay.getMchId());
    }

    protected void buildSignParams(Map<String, String> params) {
        String sign = this.doSign(params);
        this.put(params, "sign", sign);
    }

    protected String doSign(Map<String, String> params) {
        StringBuilder signing = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (Strings.isNullOrEmpty((String)entry.getValue()).booleanValue()) continue;
            signing.append(entry.getKey()).append('=').append(entry.getValue()).append("&");
        }
        signing.append("key=").append(this.wepay.getAppKey());
        return MD5.generate((String)signing.toString(), (boolean)false).toUpperCase();
    }

    protected Boolean doVerifySign(Map<String, ?> data) {
        String actualSign = String.valueOf(data.get("sign"));
        Map<String, String> signingMap = this.filterSignParams(data);
        String expectSign = this.doSign(signingMap);
        return expectSign.equals(actualSign);
    }

    protected Map<String, String> filterSignParams(Map<String, ?> params) {
        TreeMap<String, String> validParams = new TreeMap<String, String>();
        for (Map.Entry<String, ?> param : params.entrySet()) {
            if ("sign".equals(param.getKey()) || param.getValue() == null || "".equals(String.valueOf(param.getValue()))) continue;
            validParams.put(param.getKey(), String.valueOf(param.getValue()));
        }
        return validParams;
    }

    protected void putIfNotEmpty(Map<String, String> map, String field, String paramValue) {
        if (!Strings.isNullOrEmpty((String)paramValue).booleanValue()) {
            map.put(field, paramValue);
        }
    }

    protected void put(Map<String, String> map, String field, String paramValue) {
        map.put(field, paramValue);
    }
}

