/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import me.hao0.common.http.Http;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.common.xml.XmlReaders;
import me.hao0.wepay.core.Component;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.bill.Bill;
import me.hao0.wepay.model.bill.BillCount;
import me.hao0.wepay.model.bill.BillDetail;
import me.hao0.wepay.model.bill.BillFields;
import me.hao0.wepay.model.bill.CommonBill;
import me.hao0.wepay.model.bill.RefundBill;
import me.hao0.wepay.model.enums.BillType;
import me.hao0.wepay.util.Maps;
import me.hao0.wepay.util.RandomStrs;

public class Bills
extends Component {
    private static final String DOWNLOAD = "https://api.mch.weixin.qq.com/pay/downloadbill";
    private static final String LINE_SEPARATOR = "\\n";
    private static final String FIELD_SEPARATOR = ",`";

    Bills(Wepay wepay) {
        super(wepay);
    }

    public BillDetail<CommonBill> queryAll(String deviceInfo, String date) {
        String data = this.query(deviceInfo, date, BillType.ALL);
        return this.renderBillDetail(data, BillFields.ALL, CommonBill.class);
    }

    public BillDetail<Bill> querySuccess(String deviceInfo, String date) {
        String data = this.query(deviceInfo, date, BillType.SUCCESS);
        return this.renderBillDetail(data, BillFields.SUCCESS, Bill.class);
    }

    public BillDetail<RefundBill> queryRefund(String deviceInfo, String date) {
        String data = this.query(deviceInfo, date, BillType.REFUND);
        return this.renderBillDetail(data, BillFields.REFUND, RefundBill.class);
    }

    private <T extends Bill> BillDetail<T> renderBillDetail(String billData, List<String> fields, Class<T> billClazz) {
        String[] dataLines = billData.split(LINE_SEPARATOR);
        if (dataLines.length > 0) {
            ArrayList<T> bills = new ArrayList<T>();
            for (int i = 1; i < dataLines.length - 2; ++i) {
                T bill = this.renderBill(dataLines[i], fields, billClazz);
                bills.add(bill);
            }
            String countData = dataLines[dataLines.length - 1];
            BillCount count = this.renderCount(countData);
            return new BillDetail(bills, count);
        }
        return BillDetail.empty();
    }

    private BillCount renderCount(String countData) {
        countData = countData.substring(1).replaceAll("\\r", "");
        String[] fieldVals = countData.split(FIELD_SEPARATOR);
        HashMap<String, String> billCount = new HashMap<String, String>();
        List<String> fieldNames = BillFields.COUNT;
        for (int i = 0; i < fieldNames.size(); ++i) {
            billCount.put(fieldNames.get(i), fieldVals[i]);
        }
        return (BillCount)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(billCount), BillCount.class);
    }

    private <T extends Bill> T renderBill(String dataLine, List<String> fieldNames, Class<T> billClazz) {
        dataLine = dataLine.substring(1).replaceAll("\\r", "");
        String[] fieldVals = dataLine.split(FIELD_SEPARATOR);
        HashMap<String, String> billData = new HashMap<String, String>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            billData.put(fieldNames.get(i), fieldVals[i]);
        }
        return (T)((Bill)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(billData), billClazz));
    }

    public String query(String deviceInfo, String date, BillType type) {
        Preconditions.checkNotNullAndEmpty((String)date, (String)"date");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"bill type can't be null");
        Map<String, String> downloadParams = this.buildDownloadParams(deviceInfo, date, type);
        String billData = Http.post((String)DOWNLOAD).body(Maps.toXml(downloadParams)).request();
        if (billData.startsWith("<xml>")) {
            XmlReaders readers = XmlReaders.create((String)billData);
            throw new WepayException(readers.getNodeStr("return_code"), readers.getNodeStr("return_msg"));
        }
        return billData;
    }

    private Map<String, String> buildDownloadParams(String deviceInfo, String date, BillType type) {
        TreeMap<String, String> downloadParams = new TreeMap<String, String>();
        this.buildConfigParams(downloadParams);
        this.put(downloadParams, "nonce_str", RandomStrs.generate(16));
        this.put(downloadParams, "bill_type", type.type());
        this.put(downloadParams, "bill_date", date);
        this.putIfNotEmpty(downloadParams, "device_info", deviceInfo);
        this.buildSignParams(downloadParams);
        return downloadParams;
    }
}

