/*
 * Decompiled with CFR 0.152.
 */
package me.grantland.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;
import me.grantland.widget.R;

public class AutofitHelper {
    private static final String TAG = "AutoFitTextHelper";
    private static final boolean SPEW = false;
    private static final int DEFAULT_MIN_TEXT_SIZE = 8;
    private static final float DEFAULT_PRECISION = 0.5f;
    private TextView mTextView;
    private TextPaint mPaint;
    private float mTextSize;
    private int mMaxLines;
    private float mMinTextSize;
    private float mMaxTextSize;
    private float mPrecision;
    private boolean mEnabled;
    private boolean mIsAutofitting;
    private ArrayList<OnTextSizeChangeListener> mListeners;
    private TextWatcher mTextWatcher = new AutofitTextWatcher();
    private View.OnLayoutChangeListener mOnLayoutChangeListener = new AutofitOnLayoutChangeListener();

    public static AutofitHelper create(TextView view) {
        return AutofitHelper.create(view, null, 0);
    }

    public static AutofitHelper create(TextView view, AttributeSet attrs) {
        return AutofitHelper.create(view, attrs, 0);
    }

    public static AutofitHelper create(TextView view, AttributeSet attrs, int defStyle) {
        AutofitHelper helper = new AutofitHelper(view);
        boolean sizeToFit = true;
        if (attrs != null) {
            Context context = view.getContext();
            int minTextSize = (int)helper.getMinTextSize();
            float precision = helper.getPrecision();
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AutofitTextView, defStyle, 0);
            sizeToFit = ta.getBoolean(R.styleable.AutofitTextView_sizeToFit, sizeToFit);
            minTextSize = ta.getDimensionPixelSize(R.styleable.AutofitTextView_minTextSize, minTextSize);
            precision = ta.getFloat(R.styleable.AutofitTextView_precision, precision);
            ta.recycle();
            helper.setMinTextSize(0, minTextSize).setPrecision(precision);
        }
        helper.setEnabled(sizeToFit);
        return helper;
    }

    private static void autofit(TextView view, TextPaint paint, float minTextSize, float maxTextSize, int maxLines, float precision) {
        float size;
        if (maxLines <= 0 || maxLines == Integer.MAX_VALUE) {
            return;
        }
        int targetWidth = view.getWidth() - view.getPaddingLeft() - view.getPaddingRight();
        if (targetWidth <= 0) {
            return;
        }
        CharSequence text = view.getText();
        TransformationMethod method = view.getTransformationMethod();
        if (method != null) {
            text = method.getTransformation(text, (View)view);
        }
        Context context = view.getContext();
        Resources r = Resources.getSystem();
        float high = size = maxTextSize;
        float low = 0.0f;
        if (context != null) {
            r = context.getResources();
        }
        DisplayMetrics displayMetrics = r.getDisplayMetrics();
        paint.set(view.getPaint());
        paint.setTextSize(size);
        if (maxLines == 1 && paint.measureText(text, 0, text.length()) > (float)targetWidth || AutofitHelper.getLineCount(text, paint, size, targetWidth, displayMetrics) > maxLines) {
            size = AutofitHelper.getAutofitTextSize(text, paint, targetWidth, maxLines, low, high, precision, displayMetrics);
        }
        if (size < minTextSize) {
            size = minTextSize;
        }
        view.setTextSize(0, size);
    }

    private static float getAutofitTextSize(CharSequence text, TextPaint paint, float targetWidth, int maxLines, float low, float high, float precision, DisplayMetrics displayMetrics) {
        float mid = (low + high) / 2.0f;
        int lineCount = 1;
        StaticLayout layout = null;
        paint.setTextSize(TypedValue.applyDimension((int)0, (float)mid, (DisplayMetrics)displayMetrics));
        if (maxLines != 1) {
            layout = new StaticLayout(text, paint, (int)targetWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            lineCount = layout.getLineCount();
        }
        if (lineCount > maxLines) {
            if (high - low < precision) {
                return low;
            }
            return AutofitHelper.getAutofitTextSize(text, paint, targetWidth, maxLines, low, mid, precision, displayMetrics);
        }
        if (lineCount < maxLines) {
            return AutofitHelper.getAutofitTextSize(text, paint, targetWidth, maxLines, mid, high, precision, displayMetrics);
        }
        float maxLineWidth = 0.0f;
        if (maxLines == 1) {
            maxLineWidth = paint.measureText(text, 0, text.length());
        } else {
            for (int i = 0; i < lineCount; ++i) {
                if (!(layout.getLineWidth(i) > maxLineWidth)) continue;
                maxLineWidth = layout.getLineWidth(i);
            }
        }
        if (high - low < precision) {
            return low;
        }
        if (maxLineWidth > targetWidth) {
            return AutofitHelper.getAutofitTextSize(text, paint, targetWidth, maxLines, low, mid, precision, displayMetrics);
        }
        if (maxLineWidth < targetWidth) {
            return AutofitHelper.getAutofitTextSize(text, paint, targetWidth, maxLines, mid, high, precision, displayMetrics);
        }
        return mid;
    }

    private static int getLineCount(CharSequence text, TextPaint paint, float size, float width, DisplayMetrics displayMetrics) {
        paint.setTextSize(TypedValue.applyDimension((int)0, (float)size, (DisplayMetrics)displayMetrics));
        StaticLayout layout = new StaticLayout(text, paint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        return layout.getLineCount();
    }

    private static int getMaxLines(TextView view) {
        int maxLines = -1;
        TransformationMethod method = view.getTransformationMethod();
        if (method != null && method instanceof SingleLineTransformationMethod) {
            maxLines = 1;
        } else if (Build.VERSION.SDK_INT >= 16) {
            maxLines = view.getMaxLines();
        }
        return maxLines;
    }

    private AutofitHelper(TextView view) {
        Context context = view.getContext();
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.mTextView = view;
        this.mPaint = new TextPaint();
        this.setRawTextSize(view.getTextSize());
        this.mMaxLines = AutofitHelper.getMaxLines(view);
        this.mMinTextSize = scaledDensity * 8.0f;
        this.mMaxTextSize = this.mTextSize;
        this.mPrecision = 0.5f;
    }

    public AutofitHelper addOnTextSizeChangeListener(OnTextSizeChangeListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
        return this;
    }

    public AutofitHelper removeOnTextSizeChangeListener(OnTextSizeChangeListener listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
        return this;
    }

    public float getPrecision() {
        return this.mPrecision;
    }

    public AutofitHelper setPrecision(float precision) {
        if (this.mPrecision != precision) {
            this.mPrecision = precision;
            this.autofit();
        }
        return this;
    }

    public float getMinTextSize() {
        return this.mMinTextSize;
    }

    public AutofitHelper setMinTextSize(float size) {
        return this.setMinTextSize(2, size);
    }

    public AutofitHelper setMinTextSize(int unit, float size) {
        Context context = this.mTextView.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawMinTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
        return this;
    }

    private void setRawMinTextSize(float size) {
        if (size != this.mMinTextSize) {
            this.mMinTextSize = size;
            this.autofit();
        }
    }

    public float getMaxTextSize() {
        return this.mMaxTextSize;
    }

    public AutofitHelper setMaxTextSize(float size) {
        return this.setMaxTextSize(2, size);
    }

    public AutofitHelper setMaxTextSize(int unit, float size) {
        Context context = this.mTextView.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawMaxTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
        return this;
    }

    private void setRawMaxTextSize(float size) {
        if (size != this.mMaxTextSize) {
            this.mMaxTextSize = size;
            this.autofit();
        }
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public AutofitHelper setMaxLines(int lines) {
        if (this.mMaxLines != lines) {
            this.mMaxLines = lines;
            this.autofit();
        }
        return this;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public AutofitHelper setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            if (enabled) {
                this.mTextView.addTextChangedListener(this.mTextWatcher);
                this.mTextView.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
                this.autofit();
            } else {
                this.mTextView.removeTextChangedListener(this.mTextWatcher);
                this.mTextView.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
                this.mTextView.setTextSize(0, this.mTextSize);
            }
        }
        return this;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        if (this.mIsAutofitting) {
            return;
        }
        Context context = this.mTextView.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (this.mTextSize != size) {
            this.mTextSize = size;
        }
    }

    private void autofit() {
        float oldTextSize = this.mTextView.getTextSize();
        this.mIsAutofitting = true;
        AutofitHelper.autofit(this.mTextView, this.mPaint, this.mMinTextSize, this.mMaxTextSize, this.mMaxLines, this.mPrecision);
        this.mIsAutofitting = false;
        float textSize = this.mTextView.getTextSize();
        if (textSize != oldTextSize) {
            this.sendTextSizeChange(textSize, oldTextSize);
        }
    }

    private void sendTextSizeChange(float textSize, float oldTextSize) {
        if (this.mListeners == null) {
            return;
        }
        for (OnTextSizeChangeListener listener : this.mListeners) {
            listener.onTextSizeChange(textSize, oldTextSize);
        }
    }

    public static interface OnTextSizeChangeListener {
        public void onTextSizeChange(float var1, float var2);
    }

    private class AutofitOnLayoutChangeListener
    implements View.OnLayoutChangeListener {
        private AutofitOnLayoutChangeListener() {
        }

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            AutofitHelper.this.autofit();
        }
    }

    private class AutofitTextWatcher
    implements TextWatcher {
        private AutofitTextWatcher() {
        }

        public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
            AutofitHelper.this.autofit();
        }

        public void afterTextChanged(Editable editable) {
        }
    }
}

