/*
 * Decompiled with CFR 0.152.
 */
package me.grantland.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import me.grantland.autofittextview.R;

public class AutofitTextView
extends TextView {
    private static final String TAG = "AutoFitTextView";
    private static final boolean SPEW = false;
    private static final int DEFAULT_MIN_TEXT_SIZE = 8;
    private static final float PRECISION = 0.5f;
    private int mMaxLines;
    private float mMinTextSize;
    private float mMaxTextSize;
    private float mPrecision;
    private TextPaint mPaint;

    public AutofitTextView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public AutofitTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public AutofitTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        int minTextSize = (int)scaledDensity * 8;
        float precision = 0.5f;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AutofitTextView, defStyle, 0);
            minTextSize = ta.getDimensionPixelSize(0, minTextSize);
            precision = ta.getFloat(1, precision);
            ta.recycle();
        }
        this.mPaint = new TextPaint();
        this.setRawTextSize(super.getTextSize());
        this.setRawMinTextSize(minTextSize);
        this.setPrecision(precision);
    }

    public float getTextSize() {
        return this.mMaxTextSize;
    }

    public void setTextSize(int unit, float size) {
        Context context = this.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (size != this.mMaxTextSize) {
            this.mMaxTextSize = size;
            this.refitText();
        }
    }

    public float getMinTextSize() {
        return this.mMinTextSize;
    }

    public void setMinTextSize(int unit, float minSize) {
        Context context = this.getContext();
        Resources r = Resources.getSystem();
        if (context != null) {
            r = context.getResources();
        }
        this.setRawMinTextSize(TypedValue.applyDimension((int)unit, (float)minSize, (DisplayMetrics)r.getDisplayMetrics()));
    }

    public void setMinTextSize(int minSize) {
        this.setMinTextSize(2, minSize);
    }

    private void setRawMinTextSize(float minSize) {
        if (minSize != this.mMinTextSize) {
            this.mMinTextSize = minSize;
            this.refitText();
        }
    }

    public float getPrecision() {
        return this.mPrecision;
    }

    public void setPrecision(float precision) {
        if (precision != this.mPrecision) {
            this.mPrecision = precision;
            this.refitText();
        }
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setMaxLines(int maxLines) {
        super.setMaxLines(maxLines);
        if (maxLines != this.mMaxLines) {
            this.mMaxLines = maxLines;
            this.refitText();
        }
    }

    private void refitText() {
        String text = this.getText().toString();
        int targetWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        if (targetWidth > 0) {
            float size;
            Context context = this.getContext();
            Resources r = Resources.getSystem();
            float high = size = this.mMaxTextSize;
            float low = 0.0f;
            if (context != null) {
                r = context.getResources();
            }
            DisplayMetrics displayMetrics = r.getDisplayMetrics();
            this.mPaint.set(this.getPaint());
            this.mPaint.setTextSize(size);
            if (this.mMaxLines == 1 && this.mPaint.measureText(text) > (float)targetWidth || AutofitTextView.getLineCount(text, this.mPaint, size, targetWidth, displayMetrics) > this.mMaxLines) {
                size = AutofitTextView.getTextSize(text, this.mPaint, targetWidth, this.mMaxLines, low, high, this.mPrecision, displayMetrics);
            }
            if (size < this.mMinTextSize) {
                size = this.mMinTextSize;
            }
            super.setTextSize(0, size);
        }
    }

    private static float getTextSize(String text, TextPaint paint, float targetWidth, int maxLines, float low, float high, float precision, DisplayMetrics displayMetrics) {
        float mid = (low + high) / 2.0f;
        int lineCount = 1;
        StaticLayout layout = null;
        if (maxLines != 1) {
            paint.setTextSize(TypedValue.applyDimension((int)0, (float)mid, (DisplayMetrics)displayMetrics));
            layout = new StaticLayout((CharSequence)text, paint, (int)targetWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            lineCount = layout.getLineCount();
        }
        if (lineCount > maxLines) {
            return AutofitTextView.getTextSize(text, paint, targetWidth, maxLines, low, mid, precision, displayMetrics);
        }
        if (lineCount < maxLines) {
            return AutofitTextView.getTextSize(text, paint, targetWidth, maxLines, mid, high, precision, displayMetrics);
        }
        float maxLineWidth = 0.0f;
        if (maxLines == 1) {
            maxLineWidth = paint.measureText(text);
        } else {
            for (int i = 0; i < lineCount; ++i) {
                if (!(layout.getLineWidth(i) > maxLineWidth)) continue;
                maxLineWidth = layout.getLineWidth(i);
            }
        }
        if (high - low < precision) {
            return low;
        }
        if (maxLineWidth > targetWidth) {
            return AutofitTextView.getTextSize(text, paint, targetWidth, maxLines, low, mid, precision, displayMetrics);
        }
        if (maxLineWidth < targetWidth) {
            return AutofitTextView.getTextSize(text, paint, targetWidth, maxLines, mid, high, precision, displayMetrics);
        }
        return mid;
    }

    private static int getLineCount(String text, TextPaint paint, float size, float width, DisplayMetrics displayMetrics) {
        paint.setTextSize(TypedValue.applyDimension((int)0, (float)size, (DisplayMetrics)displayMetrics));
        StaticLayout layout = new StaticLayout((CharSequence)text, paint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        return layout.getLineCount();
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.refitText();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.refitText();
        }
    }
}

