/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import me.geso.webscrew.Headers;
import me.geso.webscrew.response.WebResponse;

public class RedirectResponse
implements WebResponse {
    private final String location;
    private final Headers headers;
    private final List<Cookie> cookies;

    public RedirectResponse(String location) {
        this.location = location;
        this.headers = new Headers();
        this.cookies = new ArrayList<Cookie>();
    }

    @Override
    public void write(HttpServletResponse response) throws IOException {
        for (Cookie cookie : this.cookies) {
            response.addCookie(cookie);
        }
        for (String name : this.headers.keySet()) {
            for (String value : this.headers.getAll(name)) {
                response.addHeader(name, value);
            }
        }
        response.sendRedirect(this.location);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }
}

