/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew.request.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import me.geso.webscrew.Parameters;
import me.geso.webscrew.request.WebRequest;
import me.geso.webscrew.request.WebRequestUpload;
import me.geso.webscrew.request.impl.DefaultParameters;
import me.geso.webscrew.request.impl.DefaultWebRequestUpload;
import me.geso.webscrew.request.impl.UrlEncoded;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

public class DefaultWebRequest
implements WebRequest {
    private final HttpServletRequest servletRequest;
    private Map<String, List<WebRequestUpload>> uploads;
    private Parameters queryParams;
    private Parameters bodyParams;

    public DefaultWebRequest(HttpServletRequest request, String characterEncoding) throws UnsupportedEncodingException {
        this.servletRequest = request;
        this.servletRequest.setCharacterEncoding(characterEncoding);
    }

    public DefaultWebRequest(HttpServletRequest request, Charset characterEncoding) throws UnsupportedEncodingException {
        this(request, characterEncoding.toString());
    }

    @Override
    public String getPathInfo() {
        return this.servletRequest.getPathInfo();
    }

    @Override
    public String getRemoteAddr() {
        return this.servletRequest.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return this.servletRequest.getRemoteHost();
    }

    @Override
    public String getContentType() {
        return this.servletRequest.getContentType();
    }

    @Override
    public String getUserAgent() {
        return this.getHeader("User-Agent");
    }

    @Override
    public String getHeader(String name) {
        return this.servletRequest.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return Collections.list(this.servletRequest.getHeaders(name));
    }

    @Override
    public Map<String, List<String>> getHeaderMap() {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        Enumeration headerNames = this.servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            ArrayList values = Collections.list(this.servletRequest.getHeaders(name));
            map.put(name, values);
        }
        return map;
    }

    @Override
    public int getContentLength() {
        return this.servletRequest.getContentLength();
    }

    @Override
    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    @Override
    public String getRequestURI() {
        return this.servletRequest.getRequestURI();
    }

    @Override
    public String getQueryString() {
        return this.servletRequest.getQueryString();
    }

    @Override
    public Cookie[] getCookies() {
        return this.servletRequest.getCookies();
    }

    public String getCharacterEncoding() {
        String encoding = this.servletRequest.getCharacterEncoding();
        if (encoding == null) {
            throw new IllegalStateException("HttpServletRequest#getCharacterEncoding() returns null");
        }
        return encoding;
    }

    @Override
    public List<WebRequestUpload> getAllFileItems(String parameterName) {
        this.getBodyParams();
        List<WebRequestUpload> items = this.uploads.get(parameterName);
        if (items == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(items);
    }

    @Override
    public Optional<WebRequestUpload> getFirstFileItem(String parameterName) {
        this.getBodyParams();
        List<WebRequestUpload> list = this.uploads.get(parameterName);
        if (list == null) {
            return Optional.empty();
        }
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    @Override
    public Set<String> getFileItemNames() {
        this.getBodyParams();
        return this.uploads.keySet();
    }

    protected ServletFileUpload createServletFileUpload() {
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        return new ServletFileUpload((FileItemFactory)fileItemFactory);
    }

    @Override
    public Parameters getQueryParams() {
        try {
            if (this.queryParams == null) {
                this.queryParams = UrlEncoded.parseQueryString(this.getQueryString(), this.getCharacterEncoding());
            }
            return this.queryParams;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Parameters getBodyParams() {
        try {
            if (this.bodyParams == null) {
                if (this.servletRequest.getContentType().startsWith("application/x-www-form-urlencoded")) {
                    String queryString = IOUtils.toString((InputStream)this.servletRequest.getInputStream(), (String)this.getCharacterEncoding());
                    this.bodyParams = UrlEncoded.parseQueryString(queryString, this.getCharacterEncoding());
                } else if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)) {
                    DefaultParameters.Builder bodyParamsBuilder = DefaultParameters.builder();
                    LinkedHashMap<String, List<WebRequestUpload>> uploads = new LinkedHashMap<String, List<WebRequestUpload>>();
                    ServletFileUpload servletFileUpload = this.createServletFileUpload();
                    List fileItems = servletFileUpload.parseRequest(this.servletRequest);
                    for (FileItem fileItem : fileItems) {
                        List<DefaultWebRequestUpload> list;
                        if (fileItem.isFormField()) {
                            String value = fileItem.getString(this.getCharacterEncoding());
                            bodyParamsBuilder.put(fileItem.getFieldName(), value);
                            continue;
                        }
                        DefaultWebRequestUpload upload = new DefaultWebRequestUpload(fileItem);
                        String key = fileItem.getFieldName();
                        if (uploads.containsKey(key)) {
                            list = (List)uploads.get(key);
                            list.add(upload);
                            uploads.put(fileItem.getFieldName(), list);
                            continue;
                        }
                        list = new ArrayList();
                        list.add(upload);
                        uploads.put(fileItem.getFieldName(), list);
                    }
                    this.uploads = uploads;
                    this.bodyParams = bodyParamsBuilder.build();
                }
            }
            return this.bodyParams;
        }
        catch (IOException | FileUploadException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.servletRequest.getInputStream();
    }

    public String toString() {
        return "DefaultWebRequest(servletRequest=" + this.servletRequest + ", uploads=" + this.uploads + ", queryParams=" + this.getQueryParams() + ", bodyParams=" + this.getBodyParams() + ")";
    }
}

