/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew.request.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.geso.webscrew.Parameters;

public class DefaultParameters
implements Parameters {
    private final Map<String, List<String>> map;

    public String toString() {
        return "Parameters [map=" + this.map + "]";
    }

    private DefaultParameters(Map<String, List<String>> map) {
        this.map = map;
    }

    @Override
    public Optional<String> getFirst(String name) {
        Collection collection = this.map.get(name);
        if (collection == null) {
            return Optional.empty();
        }
        return collection.stream().findFirst();
    }

    @Override
    public List<String> getAll(String name) {
        List<String> collection = this.map.get(name);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(collection);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, List<String>> map = new LinkedHashMap<String, List<String>>();

        private Builder() {
        }

        public Builder put(String key, String value) {
            if (this.map.containsKey(key)) {
                List<String> list = this.map.get(key);
                list.add(value);
                this.map.put(key, list);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(value);
                this.map.put(key, list);
            }
            return this;
        }

        public DefaultParameters build() {
            return new DefaultParameters(this.map);
        }
    }
}

