/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew.request.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.geso.webscrew.request.auth.HttpBasicAuthUserPass;

public class HttpBasicAuthHeaderParser {
    private static final Pattern pattern = Pattern.compile("\\ABasic (.*)\\z", 2);

    public static Optional<HttpBasicAuthUserPass> parse(String authHeader) {
        if (authHeader == null) {
            return Optional.empty();
        }
        Matcher matcher = pattern.matcher(authHeader);
        if (matcher.matches()) {
            byte[] decoded;
            String token = matcher.group(1);
            try {
                decoded = Base64.getDecoder().decode(token);
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
            String decodedString = new String(decoded, StandardCharsets.UTF_8);
            String[] split = decodedString.split(":", 2);
            if (split.length == 2) {
                return Optional.of(new HttpBasicAuthUserPass(split[0], split[1]));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

