/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class Headers {
    private final Map<String, List<String>> map = new TreeMap<String, List<String>>();

    public void add(String key, String value) {
        if ((key = key.toLowerCase()).contains("\n")) {
            throw new RuntimeException("You can't include new line character in header key.");
        }
        if (value.contains("\n")) {
            throw new RuntimeException("You can't include new line character in header value.");
        }
        if (!this.map.containsKey(key)) {
            this.map.put(key, new ArrayList());
        }
        this.map.get(key).add(value);
    }

    public List<String> getAll(String key) {
        List<String> list = this.map.get(key = key.toLowerCase());
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public Optional<String> getFirst(String key) {
        List<String> list = this.map.get(key = key.toLowerCase());
        if (list != null && list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Set<String> headerNames() {
        return this.map.keySet();
    }

    public void set(String key, String value) {
        if ((key = key.toLowerCase()).contains("\n")) {
            throw new RuntimeException("You can't include new line character in header key.");
        }
        if (value.contains("\n")) {
            throw new RuntimeException("You can't include new line character in header value.");
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.map.put(key, values);
    }

    public String toString() {
        return "Headers(map=" + this.map + ")";
    }
}

