/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.apache.http.client.utils.URIBuilder;

public class HttpServletRequestUtils {
    public static URL getCurrentURL(@NonNull HttpServletRequest httpServletRequest) throws MalformedURLException {
        if (httpServletRequest == null) {
            throw new NullPointerException("httpServletRequest");
        }
        StringBuffer url = httpServletRequest.getRequestURL();
        String queryString = httpServletRequest.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            url.append("?").append(httpServletRequest.getQueryString());
        }
        return new URL(url.toString());
    }

    private static URIBuilder getRelativePath(@NonNull HttpServletRequest httpServletRequest, @NonNull String path) throws MalformedURLException, URISyntaxException {
        if (httpServletRequest == null) {
            throw new NullPointerException("httpServletRequest");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (path.startsWith("/")) {
            return new URIBuilder().setScheme(httpServletRequest.getScheme()).setHost(httpServletRequest.getServerName()).setPort(httpServletRequest.getServerPort()).setPath(httpServletRequest.getContextPath() + path);
        }
        StringBuffer requestURL = httpServletRequest.getRequestURL();
        return new URIBuilder(new URL(new URL(requestURL.toString()), path).toURI());
    }

    public static URI uriFor(@NonNull HttpServletRequest httpServletRequest, @NonNull String path, @NonNull Map<String, String> parameters) throws URISyntaxException, MalformedURLException {
        if (httpServletRequest == null) {
            throw new NullPointerException("httpServletRequest");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        URIBuilder builder = HttpServletRequestUtils.getRelativePath(httpServletRequest, path);
        parameters.entrySet().stream().forEach(it -> builder.setParameter((String)it.getKey(), (String)it.getValue()));
        return builder.build();
    }

    public static URI uriWith(@NonNull HttpServletRequest httpServletRequest, Map<String, String> parameters) throws URISyntaxException, MalformedURLException {
        if (httpServletRequest == null) {
            throw new NullPointerException("httpServletRequest");
        }
        URIBuilder builder = new URIBuilder(String.valueOf(HttpServletRequestUtils.getCurrentURL(httpServletRequest)));
        parameters.entrySet().stream().forEach(it -> builder.setParameter((String)it.getKey(), (String)it.getValue()));
        return builder.build();
    }
}

