/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import me.geso.webscrew.Headers;
import me.geso.webscrew.response.WebResponse;

public class CallbackResponse
implements WebResponse {
    private final Callback callback;
    private final Headers headers;
    private final List<Cookie> cookies;
    private int statusCode;

    public CallbackResponse(@NonNull Callback callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.statusCode = 200;
        this.callback = callback;
        this.headers = new Headers();
        this.cookies = new ArrayList<Cookie>();
    }

    @Override
    public void write(HttpServletResponse response) throws IOException {
        response.setStatus(this.statusCode);
        for (Cookie cookie : this.cookies) {
            response.addCookie(cookie);
        }
        for (String name : this.headers.keySet()) {
            for (String value : this.headers.getAll(name)) {
                response.addHeader(name, value);
            }
        }
        try {
            this.callback.call(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public String toString() {
        return "CallbackResponse(callback=" + this.callback + ", headers=" + this.headers + ", cookies=" + this.cookies + ", statusCode=" + this.statusCode + ")";
    }

    @FunctionalInterface
    public static interface Callback {
        public void call(HttpServletResponse var1) throws Exception;
    }
}

