/*
 * Decompiled with CFR 0.152.
 */
package me.geso.webscrew.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import me.geso.webscrew.Headers;
import me.geso.webscrew.response.WebResponse;

public class ByteArrayResponse
implements WebResponse {
    private final Headers headers = new Headers();
    private int status = 200;
    private final byte[] body;
    private final List<Cookie> cookies = new ArrayList<Cookie>();

    public ByteArrayResponse(int status, byte[] body) {
        if (body == null) {
            throw new NullPointerException("[ByteArrayResponse] Body is null");
        }
        this.status = status;
        this.body = body;
    }

    @Override
    public void write(HttpServletResponse response) throws IOException {
        response.setStatus(this.status);
        for (Cookie cookie : this.cookies) {
            response.addCookie(cookie);
        }
        for (String key : this.getHeaders().keySet()) {
            for (String value : this.getHeaders().getAll(key)) {
                response.addHeader(key, value);
            }
        }
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(this.body);
        }
    }

    public void setContentType(String contentType) {
        this.getHeaders().add("Content-Type", contentType);
    }

    public void setContentLength(long length) {
        this.getHeaders().add("Content-Length", "" + length);
    }

    @Override
    public void addHeader(String name, String value) {
        this.getHeaders().add(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.getHeaders().set(name, value);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public String toString() {
        return "ByteArrayResponse(headers=" + this.getHeaders() + ", status=" + this.getStatus() + ", body=" + Arrays.toString(this.getBody()) + ", cookies=" + this.cookies + ")";
    }
}

