/*
 * Decompiled with CFR 0.152.
 */
package me.figo.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.figo.internal.SetupAccountCredentials;

public class GsonAdapter {
    public static Gson createGson() {
        JsonSerializer<Date> serializer = new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type type, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                String formatted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(src);
                return new JsonPrimitive(formatted);
            }
        };
        JsonDeserializer<Date> deserializer = new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                String s = json.getAsString().replace("Z", "+0000");
                try {
                    return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ").parse(s);
                }
                catch (ParseException e) {
                    return null;
                }
            }
        };
        JsonDeserializer<BigDecimal> bigDecimalDeserializer = new JsonDeserializer<BigDecimal>(){

            public BigDecimal deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return new BigDecimal(json.getAsString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        };
        JsonSerializer<SetupAccountCredentials> setupAccountCredentialsSerializer = new JsonSerializer<SetupAccountCredentials>(){

            public JsonElement serialize(SetupAccountCredentials setupAccountCredentials, Type type, JsonSerializationContext jsonSerializationContext) {
                if (setupAccountCredentials.getEncryptedCredentials() != null) {
                    JsonObject root = new JsonObject();
                    root.add("type", (JsonElement)new JsonPrimitive("encrypted"));
                    root.add("value", (JsonElement)new JsonPrimitive(setupAccountCredentials.getEncryptedCredentials()));
                    return root;
                }
                if (setupAccountCredentials.getCredentials() != null) {
                    JsonArray root = new JsonArray();
                    for (String credential : setupAccountCredentials.getCredentials()) {
                        root.add(credential);
                    }
                    return root;
                }
                return null;
            }
        };
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)serializer).registerTypeAdapter(SetupAccountCredentials.class, (Object)setupAccountCredentialsSerializer).registerTypeAdapter(Date.class, (Object)deserializer).registerTypeAdapter(BigDecimal.class, (Object)bigDecimalDeserializer).excludeFieldsWithoutExposeAnnotation().create();
    }
}

