/*
 * Decompiled with CFR 0.152.
 */
package me.figo.internal;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class FigoTrustManager
implements X509TrustManager {
    private static final List<String> VALID_FINGERPRINTS = new ArrayList<String>(Arrays.asList("CDF3D326278991B9CDAE4B106C9681B7EBB33810C472376A4D9C84B7B3DCD68D", "79B2A29300853B0692B1B5F2247948583AA5220FC5CDE9499AC8451EDBE0DA50"));

    public static List<String> getTrustedFingerprints() {
        return VALID_FINGERPRINTS;
    }

    public static void addTrustedFingerprint(String fingerprint) {
        VALID_FINGERPRINTS.add(fingerprint);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        if (certs.length == 0) {
            throw new CertificateException("No certificate found");
        }
        String thumbprint = FigoTrustManager.getThumbPrint(certs[0]);
        if (!VALID_FINGERPRINTS.contains(thumbprint) && !FigoTrustManager.getFingerprintsFromEnv().contains(thumbprint)) {
            throw new CertificateException("Fingerprint does not match certificate");
        }
    }

    private static String getThumbPrint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return new BigInteger(1, digest).toString(16).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (CertificateEncodingException e) {
            return "";
        }
    }

    private static List<String> getFingerprintsFromEnv() {
        String fingerprintList = System.getenv("FIGO_API_FINGERPRINTS");
        if (fingerprintList != null) {
            return Arrays.asList(fingerprintList.split(":"));
        }
        return new ArrayList<String>();
    }
}

