/*
 * Decompiled with CFR 0.152.
 */
package me.figo.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class FigoSocketFactory
extends SSLSocketFactory {
    private static final String[] ENABLED_PROTOCOLS = new String[]{"TLSv1.2"};
    private SSLSocketFactory isf;

    public FigoSocketFactory(SSLSocketFactory factory) {
        this.isf = factory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.isf.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.isf.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.enableProtocols(this.isf.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enableProtocols(this.isf.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String remoteHost, int remotePort, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.enableProtocols(this.isf.createSocket(remoteHost, remotePort, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableProtocols(this.isf.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress remoteHost, int remotePort, InetAddress localHost, int localPort) throws IOException {
        return this.enableProtocols(this.isf.createSocket(remoteHost, remotePort, localHost, localPort));
    }

    private Socket enableProtocols(Socket socket) {
        if (socket != null && socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(ENABLED_PROTOCOLS);
        }
        return socket;
    }
}

