/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.figo.FigoApi;
import me.figo.FigoException;
import me.figo.FigoPinException;
import me.figo.internal.ModifyStandingOrderRequest;
import me.figo.internal.SetupAccountRequest;
import me.figo.internal.SubmitPaymentRequest;
import me.figo.internal.SyncTokenRequest;
import me.figo.internal.TaskResponseType;
import me.figo.internal.TaskStatusRequest;
import me.figo.internal.TaskStatusResponse;
import me.figo.internal.TaskTokenResponse;
import me.figo.internal.VisitedRequest;
import me.figo.models.Account;
import me.figo.models.AccountBalance;
import me.figo.models.Bank;
import me.figo.models.BankLoginSettings;
import me.figo.models.Notification;
import me.figo.models.Payment;
import me.figo.models.PaymentContainer;
import me.figo.models.PaymentProposal;
import me.figo.models.Security;
import me.figo.models.Service;
import me.figo.models.ServiceLoginSettings;
import me.figo.models.StandingOrder;
import me.figo.models.Transaction;
import me.figo.models.User;

public class FigoSession
extends FigoApi {
    public FigoSession(String accessToken) {
        this(accessToken, 10000);
    }

    public FigoSession(String accessToken, int timeout) {
        super("Bearer " + accessToken, timeout);
    }

    public FigoSession(String accessToken, int timeout, String apiEndpoint) {
        super(apiEndpoint, "Bearer " + accessToken, timeout);
    }

    public User getUser() throws FigoException, IOException {
        return (User)this.queryApi("/rest/user", null, "GET", (Type)((Object)User.class));
    }

    public User updateUser(User user) throws FigoException, IOException {
        return (User)this.queryApi("/rest/user", user, "PUT", (Type)((Object)User.class));
    }

    public void removeUser() throws FigoException, IOException {
        this.queryApi("/rest/user", null, "DELETE", null);
    }

    public List<Service> getSupportedServices(String countryCode) throws FigoException, IOException {
        Service.ServiceResponse response = (Service.ServiceResponse)this.queryApi("/rest/catalog/services/" + countryCode, null, "GET", (Type)((Object)Service.ServiceResponse.class));
        return response == null ? null : response.getServices();
    }

    public List<Service> getSupportedServices() throws FigoException, IOException {
        Service.ServiceResponse response = (Service.ServiceResponse)this.queryApi("/rest/catalog/services", null, "GET", (Type)((Object)Service.ServiceResponse.class));
        return response == null ? null : response.getServices();
    }

    public BankLoginSettings getLoginSettings(String countryCode, String bankCode) throws FigoException, IOException {
        return (BankLoginSettings)this.queryApi("/rest/catalog/banks/" + countryCode + "/" + bankCode, null, "GET", (Type)((Object)BankLoginSettings.class));
    }

    public ServiceLoginSettings getLoginSettingsForService(String countryCode, String serviceName) throws IOException, FigoException {
        return (ServiceLoginSettings)this.queryApi("/rest/catalog/services/" + countryCode + "/" + serviceName, null, "GET", (Type)((Object)ServiceLoginSettings.class));
    }

    @Deprecated
    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, String loginName, String pin) throws FigoException, IOException {
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, loginName, pin), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, String loginName, String pin, List<String> syncTasks) throws FigoException, IOException {
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, loginName, pin, syncTasks), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, String loginName, String pin, List<String> syncTasks, boolean savePin, boolean disable_first_sync) throws FigoException, IOException {
        List<String> credentials = Arrays.asList(loginName, pin);
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, credentials, syncTasks, savePin, disable_first_sync), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    @Deprecated
    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, List<String> credentials) throws FigoException, IOException {
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, credentials, null), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, List<String> credentials, List<String> syncTasks) throws FigoException, IOException {
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, credentials, syncTasks), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, List<String> credentials, List<String> syncTasks, boolean savePin, boolean disable_first_sync) throws FigoException, IOException {
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, credentials, syncTasks, savePin, disable_first_sync), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse setupNewAccount(String bankCode, String countryCode, String encryptedCredentials, List<String> syncTasks, boolean savePin, boolean disable_first_sync) throws FigoException, IOException {
        return (TaskTokenResponse)this.queryApi("/rest/accounts", new SetupAccountRequest(bankCode, countryCode, encryptedCredentials, syncTasks, savePin, disable_first_sync), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    @Deprecated
    public TaskStatusResponse setupAndSyncAccount(String bankCode, String countryCode, String loginName, String pin) throws FigoException, IOException, FigoPinException, InterruptedException {
        return this.setupAndSyncAccount(bankCode, countryCode, loginName, pin, null);
    }

    public TaskStatusResponse setupAndSyncAccount(String bankCode, String countryCode, String loginName, String pin, List<String> syncTasks) throws FigoException, IOException, FigoPinException, InterruptedException {
        TaskTokenResponse tokenResponse = this.setupNewAccount(bankCode, countryCode, loginName, pin, syncTasks);
        TaskStatusResponse taskStatus = this.getTaskState(tokenResponse);
        while (!(taskStatus.isEnded() || taskStatus.isErroneous() || taskStatus.isWaitingForPin() || taskStatus.isWaitingForResponse())) {
            taskStatus = this.getTaskState(tokenResponse);
            Thread.sleep(1000L);
        }
        if (taskStatus.isWaitingForPin() && !taskStatus.isEnded()) {
            throw new FigoPinException(bankCode, countryCode, loginName, pin, tokenResponse);
        }
        if (taskStatus.isErroneous() && taskStatus.isEnded()) {
            throw new FigoException("", taskStatus.getMessage());
        }
        return taskStatus;
    }

    public TaskStatusResponse setupAndSyncAccount(FigoPinException exception, String newPin) throws FigoException, IOException, FigoPinException, InterruptedException {
        return this.setupAndSyncAccount(exception.getBankCode(), exception.getCountryCode(), exception.getLoginName(), newPin);
    }

    public List<Account> getAccounts() throws FigoException, IOException {
        Account.AccountsResponse response = (Account.AccountsResponse)this.queryApi("/rest/accounts", null, "GET", (Type)((Object)Account.AccountsResponse.class));
        return response == null ? null : response.getAccounts();
    }

    public Account getAccount(String accountId) throws FigoException, IOException {
        return (Account)this.queryApi("/rest/accounts/" + accountId, null, "GET", (Type)((Object)Account.class));
    }

    public Account updateAccount(Account account) throws FigoException, IOException {
        return (Account)this.queryApi("/rest/accounts/" + account.getAccountId(), account, "PUT", (Type)((Object)Account.class));
    }

    public void removeAccount(String accountId) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + accountId, null, "DELETE", null);
    }

    public void removeAccount(Account account) throws FigoException, IOException {
        this.removeAccount(account.getAccountId());
    }

    public AccountBalance getAccountBalance(String accountId) throws FigoException, IOException {
        return (AccountBalance)this.queryApi("/rest/accounts/" + accountId + "/balance", null, "GET", (Type)((Object)AccountBalance.class));
    }

    public AccountBalance getAccountBalance(Account account) throws FigoException, IOException {
        return this.getAccountBalance(account.getAccountId());
    }

    public AccountBalance updateAccountBalance(String accountId, AccountBalance accountBalance) throws FigoException, IOException {
        return (AccountBalance)this.queryApi("/rest/accounts/" + accountId + "/balance", accountBalance, "PUT", (Type)((Object)AccountBalance.class));
    }

    public AccountBalance updateAccountBalance(Account account, AccountBalance accountBalance) throws FigoException, IOException {
        return this.updateAccountBalance(account.getAccountId(), accountBalance);
    }

    public List<Transaction> getTransactions() throws FigoException, IOException {
        return this.getTransactions((String)null);
    }

    public List<Transaction> getTransactions(String accountId) throws FigoException, IOException {
        return this.getTransactions(accountId, null, null, null, null);
    }

    public List<Transaction> getTransactions(Account account) throws FigoException, IOException {
        return this.getTransactions(account, null, null, null, null);
    }

    public List<Transaction> getTransactions(Account account, String since, Integer count, Integer offset, PendingTransactions include_pending) throws FigoException, IOException {
        return this.getTransactions(account == null ? null : account.getAccountId(), since, count, offset, include_pending);
    }

    public List<Transaction> getTransactions(String accountId, String since, Integer count, Integer offset, PendingTransactions include_pending) throws FigoException, IOException {
        Transaction.TransactionsResponse response;
        String path = "";
        path = accountId == null ? path + "/rest/transactions?" : path + "/rest/accounts/" + accountId + "/transactions?";
        if (since != null) {
            path = path + "since=" + URLEncoder.encode(since, "ISO-8859-1") + "&";
        }
        if (count != null) {
            path = path + "count=" + count + "&";
        }
        if (offset != null) {
            path = path + "offset=" + offset + "&";
        }
        if (include_pending != null) {
            path = path + "include_pending=" + (include_pending == PendingTransactions.INCLUDED ? "1" : "0");
        }
        return (response = (Transaction.TransactionsResponse)this.queryApi(path, null, "GET", (Type)((Object)Transaction.TransactionsResponse.class))) == null ? Collections.emptyList() : response.getTransactions();
    }

    public Transaction getTransaction(String accountId, String transactionId) throws FigoException, IOException {
        return (Transaction)this.queryApi("/rest/accounts/" + accountId + "/transactions/" + transactionId, null, "GET", (Type)((Object)Transaction.class));
    }

    public void modifyTransaction(Transaction transaction, FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + transaction.getAccountId() + "/transactions/" + transaction.getTransactionId(), new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void modifyTransactions(FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/transactions", new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void modifyTransactions(Account account, FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + account.getAccountId() + "/transactions", new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void modifyTransactions(String accountId, FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + accountId + "/transactions", new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void removeTransaction(Transaction transaction) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + transaction.getAccountId() + "/transactions/" + transaction.getTransactionId(), null, "DELETE", null);
    }

    public List<StandingOrder> getStandingOrders(String accountId) throws FigoException, IOException {
        String path = "";
        path = accountId == null ? path + "/rest/standing_orders" : path + "/rest/accounts/" + accountId + "/standing_orders";
        StandingOrder.StandingOrdersResponse response = (StandingOrder.StandingOrdersResponse)this.queryApi(path, null, "GET", (Type)((Object)StandingOrder.StandingOrdersResponse.class));
        return response == null ? Collections.emptyList() : response.getStandingOrders();
    }

    public List<StandingOrder> getStandingOrders() throws FigoException, IOException {
        return this.getStandingOrders(null);
    }

    public StandingOrder getStandingOrder(String standingOrderId) throws FigoException, IOException {
        return (StandingOrder)this.queryApi("/rest/standing_orders/" + standingOrderId, null, "GET", (Type)((Object)StandingOrder.class));
    }

    public Payment modifyStandingOrder(StandingOrder updatedStandingOrder) throws IOException, FigoException {
        String accountId = updatedStandingOrder.getAccountId();
        ModifyStandingOrderRequest request = new ModifyStandingOrderRequest(updatedStandingOrder);
        return (Payment)this.queryApi("/rest/accounts/" + accountId + "/payments", request, "PUT", (Type)((Object)Payment.class));
    }

    public TaskTokenResponse deleteStandingOrder(StandingOrder standingOrder) throws IOException, FigoException {
        return (TaskTokenResponse)this.queryApi("/rest/standing_orders/" + standingOrder.getStandingOrderId(), null, "DELETE", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse deleteStandingOrder(String standingOrderId) throws IOException, FigoException {
        return (TaskTokenResponse)this.queryApi("/rest/standing_orders/" + standingOrderId, null, "DELETE", (Type)((Object)TaskTokenResponse.class));
    }

    public Security getSecurity(String accountId, String securityId) throws FigoException, IOException {
        return (Security)this.queryApi("/rest/accounts/" + accountId + "/securities/" + securityId, null, "GET", (Type)((Object)Security.class));
    }

    public Security getSecurity(Account account, String securityId) throws FigoException, IOException {
        return (Security)this.queryApi("/rest/accounts/" + account.getAccountId() + "/securities/" + securityId, null, "GET", (Type)((Object)Security.class));
    }

    public List<Security> getSecurities() throws FigoException, IOException {
        Security.SecurityResponse response = (Security.SecurityResponse)this.queryApi("/rest/securities", null, "GET", (Type)((Object)Security.SecurityResponse.class));
        return response == null ? Collections.emptyList() : response.getSecurities();
    }

    public List<Security> getSecurities(Account account) throws FigoException, IOException {
        Security.SecurityResponse response = (Security.SecurityResponse)this.queryApi("/rest/accounts/" + account.getAccountId() + "/securities", null, "GET", (Type)((Object)Security.SecurityResponse.class));
        return response == null ? Collections.emptyList() : response.getSecurities();
    }

    public List<Security> getSecurities(String accountId) throws FigoException, IOException {
        Security.SecurityResponse response = (Security.SecurityResponse)this.queryApi("/rest/accounts/" + accountId + "/securities", null, "GET", (Type)((Object)Security.SecurityResponse.class));
        return response == null ? Collections.emptyList() : response.getSecurities();
    }

    public void modifySecurity(Security security, FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + security.getAccountId() + "/securities/" + security.getSecurityId(), new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void modifySecurities(FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/securities", new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void modifySecurities(Account account, FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + account.getAccountId() + "/securities", new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public void modifySecurities(String accountId, FieldVisited visited) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + accountId + "/securities", new VisitedRequest(visited == FieldVisited.VISITED), "PUT", null);
    }

    public Bank getBank(String bankId) throws FigoException, IOException {
        return (Bank)this.queryApi("/rest/banks/" + bankId, null, "GET", (Type)((Object)Bank.class));
    }

    public Bank getBank(Account account) throws FigoException, IOException {
        return this.getBank(account.getBankId());
    }

    public Bank updateBank(Bank bank) throws FigoException, IOException {
        return (Bank)this.queryApi("/rest/banks/" + bank.getBankId(), bank, "PUT", (Type)((Object)Bank.class));
    }

    public void removeBankPin(String bankId) throws FigoException, IOException {
        this.queryApi("/rest/banks/" + bankId + "/remove_pin", null, "POST", null);
    }

    public void removeBankPin(Bank bank) throws FigoException, IOException {
        this.removeBankPin(bank.getBankId());
    }

    public List<Notification> getNotifications() throws FigoException, IOException {
        Notification.NotificationsResponse response = (Notification.NotificationsResponse)this.queryApi("/rest/notifications", null, "GET", (Type)((Object)Notification.NotificationsResponse.class));
        return response == null ? Collections.emptyList() : response.getNotifications();
    }

    public Notification getNotification(String notificationId) throws FigoException, IOException {
        return (Notification)this.queryApi("/rest/notifications/" + notificationId, null, "GET", (Type)((Object)Notification.class));
    }

    public Notification addNotification(Notification notification) throws FigoException, IOException {
        return (Notification)this.queryApi("/rest/notifications", notification, "POST", (Type)((Object)Notification.class));
    }

    public Notification updateNotification(Notification notification) throws FigoException, IOException {
        return (Notification)this.queryApi("/rest/notifications/" + notification.getNotificationId(), notification, "PUT", (Type)((Object)Notification.class));
    }

    public void removeNotification(Notification notification) throws FigoException, IOException {
        this.queryApi("/rest/notifications/" + notification.getNotificationId(), null, "DELETE", null);
    }

    public List<Payment> getPayments() throws FigoException, IOException {
        Payment.PaymentsResponse response = (Payment.PaymentsResponse)this.queryApi("/rest/payments", null, "GET", (Type)((Object)Payment.PaymentsResponse.class));
        return response == null ? Collections.emptyList() : response.getPayments();
    }

    public List<Payment> getPayments(String accountId) throws FigoException, IOException {
        Payment.PaymentsResponse response = (Payment.PaymentsResponse)this.queryApi("/rest/accounts/" + accountId + "/payments", null, "GET", (Type)((Object)Payment.PaymentsResponse.class));
        return response == null ? Collections.emptyList() : response.getPayments();
    }

    public List<Payment> getPayments(Account account) throws FigoException, IOException {
        return this.getPayments(account.getAccountId());
    }

    public Payment getPayment(String accountId, String paymentId) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + accountId + "/payments/" + paymentId, null, "GET", (Type)((Object)Payment.class));
    }

    public Payment getPayment(Account account, String paymentId) throws FigoException, IOException {
        return this.getPayment(account.getAccountId(), paymentId);
    }

    public Payment addPayment(Payment payment) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments", payment, "POST", (Type)((Object)Payment.class));
    }

    public Payment addContainerPayment(PaymentContainer container) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + container.getAccountId() + "/payments", container, "POST", (Type)((Object)PaymentContainer.class));
    }

    public List<PaymentProposal> getPaymentProposals() throws FigoException, IOException {
        PaymentProposal.PaymentProposalResponse response = (PaymentProposal.PaymentProposalResponse)this.queryApi("/rest/adress_book", null, "GET", (Type)((Object)PaymentProposal.PaymentProposalResponse.class));
        return response == null ? Collections.emptyList() : response.getPaymentProposals();
    }

    public Payment updatePayment(Payment payment) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments/" + payment.getPaymentId(), payment, "PUT", (Type)((Object)Payment.class));
    }

    public void removePayment(Payment payment) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments/" + payment.getPaymentId(), null, "DELETE", null);
    }

    public String submitPayment(Payment payment, String tanSchemeId, String state) throws FigoException, IOException {
        return this.submitPayment(payment, tanSchemeId, state, null);
    }

    public String submitPayment(Payment payment, String tanSchemeId, String state, String redirectUri) throws FigoException, IOException {
        TaskTokenResponse response = (TaskTokenResponse)this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments/" + payment.getPaymentId() + "/submit", new SubmitPaymentRequest(tanSchemeId, state, redirectUri), "POST", (Type)((Object)TaskTokenResponse.class));
        return this.getApiEndpoint() + "/task/start?id=" + response.task_token;
    }

    public String getSyncURL(String state, String redirect_url) throws FigoException, IOException {
        TaskTokenResponse response = (TaskTokenResponse)this.queryApi("/rest/sync", new SyncTokenRequest(state, redirect_url), "POST", (Type)((Object)TaskTokenResponse.class));
        return this.getApiEndpoint() + "/task/start?id=" + response.task_token;
    }

    public String getSyncURL(String state, String redirect_url, List<String> syncTasks) throws FigoException, IOException {
        TaskTokenResponse response = (TaskTokenResponse)this.queryApi("/rest/sync", new SyncTokenRequest(state, redirect_url, syncTasks), "POST", (Type)((Object)TaskTokenResponse.class));
        return this.getApiEndpoint() + "/task/start?id=" + response.task_token;
    }

    public String getSyncURL(String state, String redirect_url, List<String> syncTasks, List<String> accountIds) throws FigoException, IOException {
        TaskTokenResponse response = (TaskTokenResponse)this.queryApi("/rest/sync", new SyncTokenRequest(state, redirect_url, syncTasks, accountIds), "POST", (Type)((Object)TaskTokenResponse.class));
        return this.getApiEndpoint() + "/task/start?id=" + response.task_token;
    }

    public TaskTokenResponse createSyncTask(String state, String redirect_url, List<String> syncTasks, List<String> accountIds) throws IOException, FigoException {
        return (TaskTokenResponse)this.queryApi("/rest/sync", new SyncTokenRequest(state, redirect_url, syncTasks, accountIds), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse createSyncTask(String state, String redirect_url, List<String> syncTasks, List<String> accountIds, boolean disableNotifications, int ifNotSyncedSince, boolean autoContinue, boolean savePin) throws IOException, FigoException {
        return (TaskTokenResponse)this.queryApi("/rest/sync", new SyncTokenRequest(state, redirect_url, syncTasks, accountIds, disableNotifications, ifNotSyncedSince, autoContinue, savePin), "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskTokenResponse createSyncTask(SyncTokenRequest syncTokenRequest) throws IOException, FigoException {
        return (TaskTokenResponse)this.queryApi("/rest/sync", syncTokenRequest, "POST", (Type)((Object)TaskTokenResponse.class));
    }

    public TaskStatusResponse getTaskState(TaskTokenResponse tokenResponse) throws FigoException, IOException {
        return (TaskStatusResponse)this.queryApi("/task/progress?id=" + tokenResponse.task_token, new TaskStatusRequest(tokenResponse), "POST", (Type)((Object)TaskStatusResponse.class));
    }

    public TaskStatusResponse getTaskState(String tokenId) throws FigoException, IOException {
        return (TaskStatusResponse)this.queryApi("/task/progress?id=" + tokenId, new TaskStatusRequest(tokenId), "POST", (Type)((Object)TaskStatusResponse.class));
    }

    @Deprecated
    public TaskStatusResponse getTaskState(String tokenId, String pin) throws FigoException, IOException {
        return (TaskStatusResponse)this.queryApi("/task/progress?id=" + tokenId, new TaskStatusRequest(tokenId, pin), "POST", (Type)((Object)TaskStatusResponse.class));
    }

    public TaskStatusResponse submitResponseToTask(String tokenId, String response, TaskResponseType type) throws FigoException, IOException {
        TaskStatusRequest request = new TaskStatusRequest(tokenId);
        switch (type) {
            case PIN: {
                request.setPin(response);
                request.setSavePin("0");
                break;
            }
            case SAVE_PIN: {
                request.setPin(response);
                request.setSavePin("1");
                break;
            }
            case CHALLENGE: {
                request.setResponse(response);
                break;
            }
            case CONTINUE: {
                request.setContinue(response);
                break;
            }
        }
        return (TaskStatusResponse)this.queryApi("/task/progress?id=" + tokenId, request, "POST", (Type)((Object)TaskStatusResponse.class));
    }

    public TaskStatusResponse submitResponseToTask(TaskTokenResponse tokenResponse, String response, TaskResponseType type) throws FigoException, IOException {
        return this.submitResponseToTask(tokenResponse.getTaskToken(), response, type);
    }

    public void startTask(TaskTokenResponse tokenResponse) throws FigoException, IOException {
        this.queryApi("/task/start?id=" + tokenResponse.task_token, null, "GET", null);
    }

    public void startTask(String taskToken) throws FigoException, IOException {
        this.queryApi("/task/start?id=" + taskToken, null, "GET", null);
    }

    public void cancelTask(TaskTokenResponse tokenResponse) throws FigoException, IOException {
        this.queryApi("/task/cancel?id=" + tokenResponse.task_token, null, "POST", null);
    }

    public void cancelTask(String taskToken) throws FigoException, IOException {
        this.queryApi("/task/cancel?id=" + taskToken, null, "POST", null);
    }

    @Override
    protected <T> T processResponse(HttpURLConnection connection, Type typeOfT) throws IOException, FigoException {
        return super.processResponse(connection, typeOfT);
    }

    public static enum FieldVisited {
        VISITED,
        NOT_VISITED;

    }

    public static enum PendingTransactions {
        INCLUDED,
        EXCLUDED;

    }
}

