/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import com.google.gson.annotations.Expose;
import java.util.Map;

public class FigoException
extends Exception {
    private static final long serialVersionUID = -3645017096212930985L;
    private final String error_message;
    private final String error_description;

    public FigoException(String error_message, String error_description) {
        super(error_message);
        this.error_message = error_message;
        this.error_description = error_description;
    }

    public FigoException(String error_message, String error_description, Throwable exc) {
        super(error_message, exc);
        this.error_message = error_message;
        this.error_description = error_description;
    }

    public FigoException(ErrorResponse response) {
        this(response.getError().getCode(), response.getError().getDescription());
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public String getErrorDescription() {
        return this.error_description;
    }

    public static class ErrorObject {
        @Expose
        private String code;
        @Expose
        private Map<String, String[]> data;
        @Expose
        private String description;
        @Expose
        private String group;

        public String getDescription() {
            return this.description;
        }

        public String getCode() {
            return this.code;
        }

        public String getGroup() {
            return this.group;
        }

        public Map<String, String[]> getData() {
            return this.data;
        }

        public String toString() {
            return "ErrorObject [" + (this.code != null ? "code=" + this.code + ", " : "") + (this.data != null ? "data=" + this.data + ", " : "") + (this.description != null ? "description=" + this.description + ", " : "") + (this.group != null ? "group=" + this.group : "") + "]";
        }
    }

    public static class ErrorResponse {
        @Expose
        private ErrorObject error;

        public ErrorObject getError() {
            return this.error;
        }
    }
}

