/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.figo.FigoException;
import me.figo.internal.FigoSocketFactory;
import me.figo.internal.FigoTrustManager;
import me.figo.internal.GsonAdapter;

public class FigoApi {
    protected static final String API_FIGO_LIVE = "https://api.figo.me";
    protected static final String API_FIGO_STAGE = "https://staging.figo.me";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final String apiEndpoint;
    private final String authorization;
    private int timeout;
    private X509TrustManager trustManager;
    private Proxy proxy;

    public FigoApi(String apiEndpoint, String authorization, int timeout) {
        this.apiEndpoint = apiEndpoint;
        this.authorization = authorization;
        this.timeout = timeout;
        this.trustManager = new FigoTrustManager();
    }

    public FigoApi(String authorization, int timeout) {
        this.authorization = authorization;
        this.timeout = timeout;
        this.trustManager = new FigoTrustManager();
        String endpointEnv = System.getenv("FIGO_API_ENDPOINT");
        this.apiEndpoint = endpointEnv != null ? endpointEnv : API_FIGO_LIVE;
    }

    public void setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public <T> T queryApi(String path, Object data, String method, Type typeOfT) throws IOException, FigoException {
        URL url = new URL(this.apiEndpoint + path);
        HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        this.setupTrustManager(connection, this.trustManager);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", this.authorization);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Figo/Java 3.1.5");
        if (data != null) {
            String encodedData = this.createGson().toJson(data);
            connection.setDoOutput(true);
            connection.getOutputStream().write(encodedData.getBytes(Charset.forName("UTF-8")));
        }
        return this.processResponse(connection, typeOfT);
    }

    protected void setupTrustManager(HttpURLConnection connection, X509TrustManager trustManager) throws IOException {
        if (connection instanceof HttpsURLConnection) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
                FigoSocketFactory figoSocketFactory = new FigoSocketFactory(sc.getSocketFactory());
                ((HttpsURLConnection)connection).setSSLSocketFactory(figoSocketFactory);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Connection setup failed", e);
            }
            catch (KeyManagementException e) {
                throw new IOException("Connection setup failed", e);
            }
        }
    }

    protected <T> T processResponse(HttpURLConnection connection, Type typeOfT) throws IOException, FigoException {
        int code = connection.getResponseCode();
        if (code >= 200 && code < 300) {
            return this.handleResponse(connection.getInputStream(), typeOfT);
        }
        FigoException.ErrorResponse errorResponse = (FigoException.ErrorResponse)this.handleResponse(connection.getErrorStream(), (Type)((Object)FigoException.ErrorResponse.class));
        this.logError(errorResponse, connection);
        throw new FigoException(errorResponse);
    }

    private void logError(FigoException.ErrorResponse errorResponse, HttpURLConnection connection) {
        String errorString = errorResponse.getError().toString();
        if (connection != null) {
            errorString = errorString + " " + connection.getRequestMethod() + " " + connection.getURL().toString();
        }
        this.logger.log(Level.SEVERE, errorString);
    }

    protected <T> T handleResponse(InputStream stream, Type typeOfT) {
        if (typeOfT == null) {
            return null;
        }
        Scanner s = new Scanner(stream, "UTF-8");
        s.useDelimiter("\\A");
        String body = s.hasNext() ? s.next() : "";
        s.close();
        return (T)this.createGson().fromJson(body, typeOfT);
    }

    protected Gson createGson() {
        return GsonAdapter.createGson();
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

