/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import me.figo.FigoApi;
import me.figo.FigoException;
import me.figo.internal.CreateUserRequest;
import me.figo.internal.CreateUserResponse;
import me.figo.internal.CredentialLoginRequest;
import me.figo.internal.TokenRequest;
import me.figo.internal.TokenResponse;
import me.figo.models.BusinessProcess;
import me.figo.models.ProcessToken;
import org.apache.commons.codec.binary.Base64;

public class FigoConnection
extends FigoApi {
    protected String clientId;
    protected String clientSecret;
    protected String redirectUri;

    public FigoConnection(String clientId, String clientSecret, String redirectUri) {
        this(clientId, clientSecret, redirectUri, 10000);
    }

    public FigoConnection(String clientId, String clientSecret, String redirectUri, int timeout) {
        this(clientId, clientSecret, redirectUri, timeout, "https://api.figo.me");
    }

    public FigoConnection(String clientId, String clientSecret, String redirectUri, int timeout, String apiEndpoint) {
        super(apiEndpoint, FigoConnection.buildAuthorizationString(clientId, clientSecret), timeout);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
    }

    private static String buildAuthorizationString(String clientId1, String clientSecret1) {
        String authInfo = clientId1 + ":" + clientSecret1;
        return "Basic " + Base64.encodeBase64String((byte[])authInfo.getBytes(Charset.forName("UTF-8")));
    }

    public String getLoginUrl(String scope, String state) {
        try {
            return this.getApiEndpoint() + "/auth/code?response_type=code&client_id=" + URLEncoder.encode(this.clientId, "ISO-8859-1") + "&redirect_uri=" + URLEncoder.encode(this.redirectUri, "ISO-8859-1") + "&scope=" + URLEncoder.encode(scope, "ISO-8859-1") + "&state=" + URLEncoder.encode(state, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public TokenResponse convertAuthenticationCode(String authenticationCode) throws FigoException, IOException {
        if (!authenticationCode.startsWith("O")) {
            throw new FigoException("invalid_code", "Invalid authentication code");
        }
        return (TokenResponse)this.queryApi("/auth/token", new TokenRequest(null, authenticationCode, this.redirectUri, "authorization_code"), "POST", (Type)((Object)TokenResponse.class));
    }

    public TokenResponse convertRefreshToken(String refreshToken) throws IOException, FigoException {
        if (!refreshToken.startsWith("R")) {
            throw new FigoException("invalid_code", "Invalid authentication code");
        }
        return (TokenResponse)this.queryApi("/auth/token", new TokenRequest(refreshToken, null, this.redirectUri, "refresh_token"), "POST", (Type)((Object)TokenResponse.class));
    }

    public TokenResponse credentialLogin(String username, String password) throws IOException, FigoException {
        return (TokenResponse)this.queryApi("/auth/token", new CredentialLoginRequest(username, password), "POST", (Type)((Object)TokenResponse.class));
    }

    public void revokeToken(String token) throws IOException, FigoException {
        this.queryApi("/auth/revoke?token=" + URLEncoder.encode(token, "ISO-8859-1"), null, "GET", null);
    }

    public String addUser(String name, String email, String password, String language) throws IOException, FigoException {
        CreateUserResponse response = (CreateUserResponse)this.queryApi("/auth/user", new CreateUserRequest(name, email, password, language), "POST", (Type)((Object)CreateUserResponse.class));
        return response.recovery_password;
    }

    public TokenResponse addUserAndLogin(String name, String email, String password, String language) throws IOException, FigoException {
        CreateUserResponse response = (CreateUserResponse)this.queryApi("/auth/user", new CreateUserRequest(name, email, password, language), "POST", (Type)((Object)CreateUserResponse.class));
        return this.credentialLogin(email, password);
    }

    public void startProcess(ProcessToken processToken) throws FigoException, IOException {
        this.queryApi("/process/start?id=" + processToken.getProcessToken(), null, "GET", null);
    }

    public ProcessToken createProcess(BusinessProcess process) throws FigoException, IOException {
        return (ProcessToken)this.queryApi("/client/process", process, "POST", (Type)((Object)ProcessToken.class));
    }
}

