/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.figo.FigoException;
import me.figo.internal.FigoTrustManager;
import me.figo.internal.GsonAdapter;

public class FigoApi {
    private final String apiEndpoint;
    private final String authorization;
    private int timeout;
    private X509TrustManager trustManager;
    private Proxy proxy;

    public FigoApi(String apiEndpoint, String authorization, int timeout) {
        this.apiEndpoint = apiEndpoint;
        this.authorization = authorization;
        this.timeout = timeout;
        this.trustManager = new FigoTrustManager();
    }

    public void setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public <T> T queryApi(String path, Object data, String method, Type typeOfT) throws IOException, FigoException {
        URL url = new URL(this.apiEndpoint + path);
        HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        this.setupTrustManager(connection, this.trustManager);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", this.authorization);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        if (data != null) {
            String encodedData = this.createGson().toJson(data);
            connection.setDoOutput(true);
            connection.getOutputStream().write(encodedData.getBytes(Charset.forName("UTF-8")));
        }
        return this.processResponse(connection, typeOfT);
    }

    protected void setupTrustManager(HttpURLConnection connection, X509TrustManager trustManager) throws IOException {
        if (connection instanceof HttpsURLConnection) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sc.getSocketFactory());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Connection setup failed", e);
            }
            catch (KeyManagementException e) {
                throw new IOException("Connection setup failed", e);
            }
        }
    }

    protected <T> T processResponse(HttpURLConnection connection, Type typeOfT) throws IOException, FigoException {
        int code = connection.getResponseCode();
        if (code >= 200 && code < 300) {
            return this.handleResponse(connection.getInputStream(), typeOfT);
        }
        if (code == 400) {
            throw new FigoException((FigoException.ErrorResponse)this.handleResponse(connection.getErrorStream(), (Type)((Object)FigoException.ErrorResponse.class)));
        }
        if (code == 401) {
            throw new FigoException("access_denied", "Access Denied");
        }
        if (code == 404) {
            throw new FigoException("Entry not found.", null);
        }
        throw new FigoException("internal_server_error", "We are very sorry, but something went wrong");
    }

    protected <T> T handleResponse(InputStream stream, Type typeOfT) {
        if (typeOfT == null) {
            return null;
        }
        Scanner s = new Scanner(stream, "UTF-8");
        s.useDelimiter("\\A");
        String body = s.hasNext() ? s.next() : "";
        s.close();
        return (T)this.createGson().fromJson(body, typeOfT);
    }

    protected Gson createGson() {
        return GsonAdapter.createGson();
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

