/*
 * Decompiled with CFR 0.152.
 */
package me.figo.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Hex;

public class FigoTrustManager
implements X509TrustManager {
    private static final List<String> VALID_FINGERPRINTS = new ArrayList<String>(Arrays.asList("38AE4A326F16EA1581338BB0D8E4A635E727F107", "CFC1BC7F6A16092B10838AB0224F3A65D270D73E"));

    public static List<String> getTrustedFingerprints() {
        return VALID_FINGERPRINTS;
    }

    public static void addTrustedFingerprint(String fingerprint) {
        VALID_FINGERPRINTS.add(fingerprint);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        if (certs.length == 0) {
            throw new CertificateException("No certificate found");
        }
        String thumbprint = FigoTrustManager.getThumbPrint(certs[0]);
        if (!VALID_FINGERPRINTS.contains(thumbprint)) {
            throw new CertificateException();
        }
    }

    private static String getThumbPrint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return new String(Hex.encodeHex((byte[])digest, (boolean)false));
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (CertificateEncodingException e) {
            return "";
        }
    }
}

