/*
 * Decompiled with CFR 0.152.
 */
package me.figo.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class FigoTrustManager
implements X509TrustManager {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static List<String> VALID_FINGERPRINTS = Arrays.asList("3A:62:54:4D:86:B4:34:38:EA:34:64:4E:95:10:A9:FF:37:27:69:C0", "CF:C1:BC:7F:6A:16:09:2B:10:83:8A:B0:22:4F:3A:65:D2:70:D7:3E");

    public static List<String> getTrustedFingerprints() {
        return VALID_FINGERPRINTS;
    }

    public static void addTrustedFingerprint(String fingerprint) {
        VALID_FINGERPRINTS.add(fingerprint);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        if (certs.length == 0) {
            throw new CertificateException("No certificate found");
        }
        String thumbprint = FigoTrustManager.getThumbPrint(certs[0]);
        if (!VALID_FINGERPRINTS.contains(thumbprint)) {
            throw new CertificateException();
        }
    }

    private static String getThumbPrint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return FigoTrustManager.hexify(digest);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (CertificateEncodingException e) {
            return "";
        }
    }

    private static String hexify(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
            if (i + 1 < bytes.length) {
                buf.append(":");
            }
            ++i;
        }
        return buf.toString();
    }
}

