/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.List;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import me.figo.FigoException;
import me.figo.internal.FigoTrustManager;
import me.figo.internal.GsonAdapter;
import me.figo.internal.SubmitPaymentRequest;
import me.figo.internal.SyncTokenRequest;
import me.figo.internal.TaskTokenResponse;
import me.figo.models.Account;
import me.figo.models.AccountBalance;
import me.figo.models.Bank;
import me.figo.models.Notification;
import me.figo.models.Payment;
import me.figo.models.Transaction;
import me.figo.models.User;

public class FigoSession {
    protected String apiEndpoint;
    protected String access_token;
    protected int timeout;

    public FigoSession(String accessToken) {
        this(accessToken, 5000);
    }

    public FigoSession(String accessToken, int timeout) {
        this(accessToken, timeout, "https://api.figo.me");
    }

    public FigoSession(String accessToken, int timeout, String apiEndpoint) {
        this.access_token = accessToken;
        this.timeout = timeout;
        this.apiEndpoint = apiEndpoint;
    }

    protected <T> T queryApi(String path, Object data, String method, Type typeOfT) throws FigoException, IOException {
        int code;
        HttpURLConnection connection = (HttpURLConnection)new URL(String.valueOf(this.apiEndpoint) + path).openConnection();
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        if (connection instanceof HttpsURLConnection) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{new FigoTrustManager()}, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                throw new IOException("Connection setup failed", e);
            }
        }
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", "Bearer " + this.access_token);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        if (data != null) {
            String encodedData = this.createGson().toJson(data);
            connection.setDoOutput(true);
            connection.getOutputStream().write(encodedData.getBytes("UTF-8"));
        }
        if ((code = connection.getResponseCode()) >= 200 && code < 300) {
            if (typeOfT == null) {
                return null;
            }
            return this.handleResponse(connection.getInputStream(), typeOfT);
        }
        if (code == 400) {
            throw new FigoException((FigoException.ErrorResponse)this.handleResponse(connection.getErrorStream(), (Type)((Object)FigoException.ErrorResponse.class)));
        }
        if (code == 401) {
            throw new FigoException("access_denied", "Access Denied");
        }
        if (code == 404) {
            return null;
        }
        throw new FigoException("internal_server_error", "We are very sorry, but something went wrong");
    }

    protected Gson createGson() {
        return GsonAdapter.createGson();
    }

    private <T> T handleResponse(InputStream stream, Type typeOfT) {
        if (typeOfT == null) {
            return null;
        }
        Scanner s = new Scanner(stream, "UTF-8");
        s.useDelimiter("\\A");
        String body = s.hasNext() ? s.next() : "";
        s.close();
        return (T)this.createGson().fromJson(body, typeOfT);
    }

    public User getUser() throws FigoException, IOException {
        return (User)this.queryApi("/rest/user", null, "GET", (Type)((Object)User.class));
    }

    public User updateUser(User user) throws FigoException, IOException {
        return (User)this.queryApi("/rest/user", user, "PUT", (Type)((Object)User.class));
    }

    public void removeUser() throws FigoException, IOException {
        this.queryApi("/rest/user", null, "DELETE", null);
    }

    public List<Account> getAccounts() throws FigoException, IOException {
        Account.AccountsResponse response = (Account.AccountsResponse)this.queryApi("/rest/accounts", null, "GET", (Type)((Object)Account.AccountsResponse.class));
        return response == null ? null : response.getAccounts();
    }

    public Account getAccount(String accountId) throws FigoException, IOException {
        return (Account)this.queryApi("/rest/accounts/" + accountId, null, "GET", (Type)((Object)Account.class));
    }

    public Account updateAccount(Account account) throws FigoException, IOException {
        return (Account)this.queryApi("/rest/accounts/" + account.getAccountId(), account, "PUT", (Type)((Object)Account.class));
    }

    public void removeAccount(String accountId) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + accountId, null, "DELETE", null);
    }

    public void removeAccount(Account account) throws FigoException, IOException {
        this.removeAccount(account.getAccountId());
    }

    public AccountBalance getAccountBalance(String accountId) throws FigoException, IOException {
        return (AccountBalance)this.queryApi("/rest/accounts/" + accountId + "/balance", null, "GET", (Type)((Object)AccountBalance.class));
    }

    public AccountBalance getAccountBalance(Account account) throws FigoException, IOException {
        return this.getAccountBalance(account.getAccountId());
    }

    public AccountBalance updateAccountBalance(String accountId, AccountBalance accountBalance) throws FigoException, IOException {
        return (AccountBalance)this.queryApi("/rest/accounts/" + accountId + "/balance", accountBalance, "PUT", (Type)((Object)AccountBalance.class));
    }

    public AccountBalance updateAccountBalance(Account account, AccountBalance accountBalance) throws FigoException, IOException {
        return this.updateAccountBalance(account.getAccountId(), accountBalance);
    }

    public List<Transaction> getTransactions() throws FigoException, IOException {
        return this.getTransactions((String)null);
    }

    public List<Transaction> getTransactions(String accountId) throws FigoException, IOException {
        return this.getTransactions(accountId, null, null, null, null);
    }

    public List<Transaction> getTransactions(Account account) throws FigoException, IOException {
        return this.getTransactions(account, null, null, null, null);
    }

    public List<Transaction> getTransactions(Account account, String since, Integer count, Integer offset, Boolean include_pending) throws FigoException, IOException {
        return this.getTransactions(account == null ? null : account.getAccountId(), since, count, offset, include_pending);
    }

    public List<Transaction> getTransactions(String accountId, String since, Integer count, Integer offset, Boolean include_pending) throws FigoException, IOException {
        Transaction.TransactionsResponse response;
        StringBuilder sb = new StringBuilder();
        if (accountId == null) {
            sb.append("/rest/transactions?");
        } else {
            sb.append("/rest/accounts/" + accountId + "/transactions?");
        }
        if (since != null) {
            sb.append("since=");
            sb.append(URLEncoder.encode(since, "ISO-8859-1"));
            sb.append("&");
        }
        if (count != null) {
            sb.append("count=");
            sb.append(count);
            sb.append("&");
        }
        if (offset != null) {
            sb.append("offset=");
            sb.append(offset);
            sb.append("&");
        }
        if (include_pending != null) {
            sb.append("include_pending=");
            sb.append(include_pending != false ? "1" : "0");
        }
        return (response = (Transaction.TransactionsResponse)this.queryApi(sb.toString(), null, "GET", (Type)((Object)Transaction.TransactionsResponse.class))) == null ? null : response.getTransactions();
    }

    public Transaction getTransaction(String accountId, String transactionId) throws FigoException, IOException {
        return (Transaction)this.queryApi("/rest/accounts/" + accountId + "/transactions/" + transactionId, null, "GET", (Type)((Object)Transaction.class));
    }

    public Bank getBank(String bankId) throws FigoException, IOException {
        return (Bank)this.queryApi("/rest/banks/" + bankId, null, "GET", (Type)((Object)Bank.class));
    }

    public Bank getBank(Account account) throws FigoException, IOException {
        return this.getBank(account.getBankId());
    }

    public Bank updateBank(Bank bank) throws FigoException, IOException {
        return (Bank)this.queryApi("/rest/banks/" + bank.getBankId(), bank, "PUT", (Type)((Object)Bank.class));
    }

    public void removeBankPin(String bankId) throws FigoException, IOException {
        this.queryApi("/rest/banks/" + bankId + "/remove_pin", null, "POST", null);
    }

    public void removeBankPin(Bank bank) throws FigoException, IOException {
        this.removeBankPin(bank.getBankId());
    }

    public List<Notification> getNotifications() throws FigoException, IOException {
        Notification.NotificationsResponse response = (Notification.NotificationsResponse)this.queryApi("/rest/notifications", null, "GET", (Type)((Object)Notification.NotificationsResponse.class));
        return response == null ? null : response.getNotifications();
    }

    public Notification getNotification(String notificationId) throws FigoException, IOException {
        return (Notification)this.queryApi("/rest/notifications/" + notificationId, null, "GET", (Type)((Object)Notification.class));
    }

    public Notification addNotification(Notification notification) throws FigoException, IOException {
        return (Notification)this.queryApi("/rest/notifications", notification, "POST", (Type)((Object)Notification.class));
    }

    public Notification updateNotification(Notification notification) throws FigoException, IOException {
        return (Notification)this.queryApi("/rest/notifications/" + notification.getNotificationId(), notification, "PUT", (Type)((Object)Notification.class));
    }

    public void removeNotification(Notification notification) throws FigoException, IOException {
        this.queryApi("/rest/notifications/" + notification.getNotificationId(), null, "DELETE", null);
    }

    public List<Payment> getPayments() throws FigoException, IOException {
        Payment.PaymentsResponse response = (Payment.PaymentsResponse)this.queryApi("/rest/payments", null, "GET", (Type)((Object)Payment.PaymentsResponse.class));
        return response == null ? null : response.getPayments();
    }

    public List<Payment> getPayments(String accountId) throws FigoException, IOException {
        Payment.PaymentsResponse response = (Payment.PaymentsResponse)this.queryApi("/rest/accounts/" + accountId + "/payments", null, "GET", (Type)((Object)Payment.PaymentsResponse.class));
        return response == null ? null : response.getPayments();
    }

    public List<Payment> getPayments(Account account) throws FigoException, IOException {
        return this.getPayments(account.getAccountId());
    }

    public Payment getPayment(String accountId, String paymentId) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + accountId + "/payments/" + paymentId, null, "GET", (Type)((Object)Payment.class));
    }

    public Payment getPayment(Account account, String paymentId) throws FigoException, IOException {
        return this.getPayment(account.getAccountId(), paymentId);
    }

    public Payment addPayment(Payment payment) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments", payment, "POST", (Type)((Object)Payment.class));
    }

    public Payment updatePayment(Payment payment) throws FigoException, IOException {
        return (Payment)this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments/" + payment.getPaymentId(), payment, "PUT", (Type)((Object)Payment.class));
    }

    public void removePayment(Payment payment) throws FigoException, IOException {
        this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments/" + payment.getPaymentId(), null, "DELETE", null);
    }

    public String submitPayment(Payment payment, String tanSchemeId, String state) throws FigoException, IOException {
        return this.submitPayment(payment, tanSchemeId, state, null);
    }

    public String submitPayment(Payment payment, String tanSchemeId, String state, String redirectUri) throws FigoException, IOException {
        TaskTokenResponse response = (TaskTokenResponse)this.queryApi("/rest/accounts/" + payment.getAccountId() + "/payments/" + payment.getPaymentId() + "/submit", new SubmitPaymentRequest(tanSchemeId, state, redirectUri), "POST", (Type)((Object)TaskTokenResponse.class));
        return String.valueOf(this.apiEndpoint) + "/task/start?id=" + response.task_token;
    }

    public String getSyncURL(String state, String redirect_url) throws FigoException, IOException {
        TaskTokenResponse response = (TaskTokenResponse)this.queryApi("/rest/sync", new SyncTokenRequest(state, redirect_url), "POST", (Type)((Object)TaskTokenResponse.class));
        return String.valueOf(this.apiEndpoint) + "/task/start?id=" + response.task_token;
    }
}

