/*
 * Decompiled with CFR 0.152.
 */
package me.figo;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Scanner;
import me.figo.FigoException;
import me.figo.internal.CreateUserRequest;
import me.figo.internal.CreateUserResponse;
import me.figo.internal.GsonAdapter;
import me.figo.internal.TokenRequest;
import me.figo.internal.TokenResponse;
import org.apache.commons.codec.binary.Base64;

public class FigoConnection {
    protected String apiEndpoint;
    protected String clientId;
    protected String clientSecret;
    private String basicAuthInfo;
    protected String redirectUri;
    private int timeout;

    public FigoConnection(String clientId, String clientSecret, String redirectUri) {
        this(clientId, clientSecret, redirectUri, 5000);
    }

    public FigoConnection(String clientId, String clientSecret, String redirectUri, int timeout) {
        this(clientId, clientSecret, redirectUri, timeout, "https://api.figo.me");
    }

    public FigoConnection(String clientId, String clientSecret, String redirectUri, int timeout, String apiEndpoint) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.timeout = timeout;
        this.apiEndpoint = apiEndpoint;
        String authInfo = String.valueOf(this.clientId) + ":" + this.clientSecret;
        this.basicAuthInfo = Base64.encodeBase64String((byte[])authInfo.getBytes());
    }

    protected <T> T queryApi(String path, Object data, String method, Type typeOfT) throws IOException, FigoException {
        int code;
        URL url = new URL(String.valueOf(this.apiEndpoint) + path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", "Basic " + this.basicAuthInfo);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        if (data != null) {
            String encodedData = this.createGson().toJson(data);
            connection.setDoOutput(true);
            connection.getOutputStream().write(encodedData.getBytes("UTF-8"));
        }
        if ((code = connection.getResponseCode()) >= 200 && code < 300) {
            return this.handleResponse(connection.getInputStream(), typeOfT);
        }
        if (code == 400) {
            throw new FigoException((FigoException.ErrorResponse)this.handleResponse(connection.getErrorStream(), (Type)((Object)FigoException.ErrorResponse.class)));
        }
        if (code == 401) {
            throw new FigoException("access_denied", "Access Denied");
        }
        throw new FigoException("internal_server_error", "We are very sorry, but something went wrong");
    }

    protected Gson createGson() {
        return GsonAdapter.createGson();
    }

    private <T> T handleResponse(InputStream stream, Type typeOfT) {
        if (typeOfT == null) {
            return null;
        }
        Scanner s = new Scanner(stream, "UTF-8");
        s.useDelimiter("\\A");
        String body = s.hasNext() ? s.next() : "";
        s.close();
        return (T)this.createGson().fromJson(body, typeOfT);
    }

    public String getLoginUrl(String scope, String state) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.apiEndpoint);
            sb.append("/auth/code?response_type=code&client_id=");
            sb.append(URLEncoder.encode(this.clientId, "ISO-8859-1"));
            sb.append("&redirect_uri=");
            sb.append(URLEncoder.encode(this.redirectUri, "ISO-8859-1"));
            sb.append("&scope=");
            sb.append(URLEncoder.encode(scope, "ISO-8859-1"));
            sb.append("&state=");
            sb.append(URLEncoder.encode(state, "ISO-8859-1"));
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public TokenResponse convertAuthenticationCode(String authenticationCode) throws FigoException, IOException {
        if (!authenticationCode.startsWith("O")) {
            throw new FigoException("invalid_code", "Invalid authentication code");
        }
        return (TokenResponse)this.queryApi("/auth/token", new TokenRequest(null, authenticationCode, this.redirectUri, "authorization_code"), "POST", (Type)((Object)TokenResponse.class));
    }

    public TokenResponse convertRefreshToken(String refreshToken) throws IOException, FigoException {
        if (!refreshToken.startsWith("R")) {
            throw new FigoException("invalid_code", "Invalid authentication code");
        }
        return (TokenResponse)this.queryApi("/auth/token", new TokenRequest(refreshToken, null, this.redirectUri, "refresh_token"), "POST", (Type)((Object)TokenResponse.class));
    }

    public void revokeToken(String token) throws IOException, FigoException {
        try {
            this.queryApi("/auth/revoke?token=" + URLEncoder.encode(token, "ISO-8859-1"), null, "GET", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String addUser(String name, String email, String password, String language, boolean send_newsletter) throws IOException, FigoException {
        CreateUserResponse response = (CreateUserResponse)this.queryApi("/auth/user", new CreateUserRequest(name, email, password, language, send_newsletter), "POST", (Type)((Object)CreateUserResponse.class));
        return response.recovery_password;
    }
}

